/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.event.ElasticConfigUpdatedEvent;
import com.atlassian.event.api.EventPublisher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElasticAccountBeanImpl
implements ElasticAccountBean {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final EventPublisher eventPublisher;

    public ElasticAccountBeanImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, EventPublisher eventManager) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.eventPublisher = eventManager;
    }

    @Nullable
    public ElasticConfiguration getElasticConfig() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
    }

    public boolean isElasticSupportEnabled() {
        ElasticConfiguration elasticConfiguration = this.getElasticConfig();
        return elasticConfiguration != null && elasticConfiguration.isEnabled();
    }

    public void saveElasticConfig(@NotNull ElasticConfiguration elasticConfiguration) {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setElasticConfig(elasticConfiguration);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        this.eventPublisher.publish((Object)new ElasticConfigUpdatedEvent((Object)this));
    }
}

