/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.Ipv6Range;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfigurationBuilder;
import com.atlassian.aws.ec2.Protocol;
import com.atlassian.aws.ec2.awssdk.Ec2AccountAttributes;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.atlassian.aws.ec2.model.VpcId;
import com.atlassian.bamboo.agent.elastic.ElasticResourceNamingHelper;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.server.Ec2PrivateKeyHandlerImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManagementListener;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.server.ShutdownOrderComparator;
import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.dao.ElasticTunnelDefinitionDao;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.event.analytics.ElasticInstanceStartedAnalyticsEvent;
import com.atlassian.bamboo.event.elastic.ElasticImageFailedToStartEvent;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.persistence.HibernateLazyReferences;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.ElasticTunnelDefinitionImpl;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.fugue.Either;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Transactional;

public class ElasticFunctionalityFacadeImpl
implements ElasticFunctionalityFacade {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ElasticFunctionalityFacadeImpl.class);
    private static final int DEFAULT_RDP_PORT = 3389;
    private static final String BUILD_ELASTIC_INTRODUCED = "1205";
    static final String AVAILABILITY_ZONE_STATUS_AVAILABLE = "available";
    private static final String ANY_IPV4_ADDRESS = "0.0.0.0/0";
    private static final String ANY_IPV6_ADDRESS = "::/0";
    @Inject
    private AgentManager agentManager;
    @Inject
    private ApplicationConfiguration applicationConfig;
    @Inject
    private AwsAccountBean awsAccountBean;
    @Inject
    private ElasticInstanceManager elasticInstanceManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private RemoteAgentManager remoteAgentManager;
    @Inject
    private StopBuildManager stopBuildManager;
    @Inject
    private ElasticAccountBean elasticAccountBean;
    @Inject
    private BambooLicenseManager bambooLicenseManager;
    @Inject
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ElasticTunnelDefinitionDao elasticTunnelDefinitionDao;
    @Inject
    private SecretEncryptionService secretEncryptionService;
    private Ec2PrivateKeyHandlerImpl ec2PrivateKeyHandler;

    @PostConstruct
    public void postConstruct() {
        this.ec2PrivateKeyHandler = new Ec2PrivateKeyHandlerImpl(this.awsAccountBean);
    }

    public void recheckElasticSupportEnabledFlag() {
        String currentBuildNumber;
        Comparator comparator = Comparators.getApplicationBuildNumberComparator();
        if (comparator.compare(currentBuildNumber = this.applicationConfig.getBuildNumber(), BUILD_ELASTIC_INTRODUCED) >= 0) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            this.setElasticSupportEnabled(this.isElasticSupportPossible((ErrorCollection)errors) && this.isElasticSupportEnabled());
        } else {
            log.warn((Object)"Did not update elastic bamboo support as the build is still too old.");
        }
    }

    public void shutdownInstance(@NotNull RemoteElasticInstance elasticInstance) {
        BuildAgent buildAgent = this.agentManager.getAgent(elasticInstance.getRemoteAgent());
        if (buildAgent != null) {
            this.remoteAgentManager.stopRemoteAgent(buildAgent);
        }
        elasticInstance.setRemoteAgent(-1L);
        elasticInstance.setAgentLoading(false);
        elasticInstance.terminate();
        this.addElasticLogEntry(log, this.textProvider.getText("elastic.configure.message.instanceTerminationRequest", new String[]{elasticInstance.getInstance().getInstanceId()}));
    }

    public void shutdownInstance(String instanceId) throws AWSException {
        RemoteElasticInstance elasticInstance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(instanceId);
        if (elasticInstance == null) {
            log.error((Object)("Could not find instance with id " + instanceId + ", instance could not be deleted"));
            throw new AWSException("Could not find instance with id " + instanceId + ", instance could not be deleted");
        }
        this.shutdownInstance(elasticInstance);
    }

    public void shutdownAllInstances() {
        List elasticInstances = this.elasticInstanceManager.getElasticRemoteAgents();
        for (RemoteElasticInstance elasticInstance : elasticInstances) {
            this.shutdownInstance(elasticInstance);
        }
    }

    @Transactional
    public void startupAgents(@NotNull Collection<ElasticImageConfiguration> elasticImageConfigurations) throws AWSException {
        List<ElasticImageConfiguration> imageConfigurationsInOurSession = elasticImageConfigurations.stream().map(imageConfiguration -> this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(imageConfiguration.getId())).peek(HibernateLazyReferences::initialise).collect(Collectors.toList());
        assert (imageConfigurationsInOurSession != null);
        this.startInstancesInternal(imageConfigurationsInOurSession);
    }

    private void startInstancesInternal(Collection<ElasticImageConfiguration> elasticImageConfigurations) throws AWSException {
        SimpleErrorCollection simpleErrorCollection;
        int numAgentsToStart = elasticImageConfigurations.size();
        if (!this.validateAgentCreation(numAgentsToStart, (ErrorCollection)(simpleErrorCollection = new SimpleErrorCollection()))) {
            StringBuilder stringBuilder = new StringBuilder();
            Collection errors = simpleErrorCollection.getErrorMessages();
            for (String error : errors) {
                stringBuilder.append(error);
            }
            String errorMessage = stringBuilder.toString();
            throw new AWSException(errorMessage.isEmpty() ? "Agent creation is not allowed." : stringBuilder.toString());
        }
        AWSAccount account = this.awsAccountBean.getAwsAccount();
        try {
            Multimap<SubnetId, SecurityGroupId> subnet2securityGroup = this.ensureSecurityGroupsExist(account, ElasticInstanceManager.ELASTIC_BAMBOO_SECURITY_GROUP, elasticImageConfigurations);
            String keyPair = ElasticInstanceManager.ELASTIC_BAMBOO_KEY_PAIR;
            this.elasticInstanceManager.ensureLoginKeyPairExists(account, keyPair);
            for (ElasticImageConfiguration elasticImageConfiguration : elasticImageConfigurations) {
                if (ElasticFunctionalityFacadeImpl.areAvailabilityZonesAvailable(account, elasticImageConfiguration)) {
                    InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder = new InstanceLaunchConfigurationBuilder();
                    instanceLaunchConfigurationBuilder.withTag("Name", ElasticResourceNamingHelper.getInstanceTag()).withKeyName(keyPair).withAvailableSecurityGroups(subnet2securityGroup);
                    RemoteElasticInstance elasticInstance = this.elasticInstanceManager.newElasticAgent((RemoteElasticInstanceListener)new ElasticInstanceManagementListener(this.elasticInstanceManager, this.eventPublisher), account, this.agentManager, elasticImageConfiguration, instanceLaunchConfigurationBuilder);
                    elasticInstance.start();
                    this.addElasticLogEntry(log, this.textProvider.getText("elastic.configure.message.newInstanceForConfiguration", new String[]{elasticImageConfiguration.getConfigurationName(), elasticImageConfiguration.getAmiId()}));
                    this.eventPublisher.publish((Object)new ElasticInstanceStartedAnalyticsEvent(elasticImageConfiguration));
                    continue;
                }
                this.addElasticLogEntry(log, this.textProvider.getText("elastic.configure.error.unavailableAvailabilityZone", new String[]{elasticImageConfiguration.getConfigurationName(), StringUtils.defaultString((String)elasticImageConfiguration.getAvailabilityZones().toString(), (String)"Default")}));
            }
        }
        catch (Exception e) {
            Set<Long> elasticImageConfigurationIds = elasticImageConfigurations.stream().map(BambooIdProvider::getId).collect(Collectors.toSet());
            elasticImageConfigurationIds.forEach(id -> this.eventPublisher.publish((Object)new ElasticImageFailedToStartEvent(id.longValue())));
            throw new AWSException("Error when starting a new instance", (Throwable)e);
        }
    }

    public void restoreAgent(@NotNull ElasticAgentDefinition elasticAgentDefinition, @NotNull Instance instance, @NotNull AWSAccount awsAccount) {
        try {
            Multimap<SubnetId, SecurityGroupId> subnet2securityGroup = this.ensureSecurityGroupsExist(awsAccount, ElasticInstanceManager.ELASTIC_BAMBOO_SECURITY_GROUP, (Iterable<ElasticImageConfiguration>)ImmutableList.of((Object)elasticAgentDefinition.getElasticImageConfiguration()));
            String keyPair = ElasticInstanceManager.ELASTIC_BAMBOO_KEY_PAIR;
            InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder = new InstanceLaunchConfigurationBuilder();
            instanceLaunchConfigurationBuilder.withKeyName(keyPair).withAvailableSecurityGroups(subnet2securityGroup);
            this.elasticInstanceManager.restoreElasticAgent(elasticAgentDefinition, this.elasticTunnelDefinitionDao.findByAgentId(elasticAgentDefinition.getId()), instance, (RemoteElasticInstanceListener)new ElasticInstanceManagementListener(this.elasticInstanceManager, this.eventPublisher), awsAccount, this.agentManager, instanceLaunchConfigurationBuilder);
        }
        catch (Exception e) {
            log.error((Object)("Error while restoring instance " + elasticAgentDefinition.getElasticInstanceId() + ", terminating."), (Throwable)e);
            try {
                awsAccount.shutdownInstance(elasticAgentDefinition.getElasticInstanceId());
            }
            catch (AWSException e1) {
                log.warn((Object)"", (Throwable)e1);
            }
        }
    }

    @Nullable
    public void persistTunnelDataOfInstance(@NotNull ElasticAgentDefinition pipelineDefinition) {
        RemoteElasticInstance remoteElasticInstance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(pipelineDefinition.getElasticInstanceId());
        if (remoteElasticInstance == null) {
            log.info((Object)("No instance data for instance " + pipelineDefinition.getElasticInstanceId() + ", skip tunnel data persisting."));
            return;
        }
        ElasticTunnelDefinitionImpl elasticTunnelDefinition = new ElasticTunnelDefinitionImpl();
        elasticTunnelDefinition.setElasticAgentDefinition(pipelineDefinition);
        elasticTunnelDefinition.setKeyStore(remoteElasticInstance.getKeyStore(), this.secretEncryptionService);
        this.elasticTunnelDefinitionDao.save((BambooObject)elasticTunnelDefinition);
    }

    private SetMultimap<VpcId, SubnetId> getVpcsAndSubnets(AWSAccount account, Iterable<ElasticImageConfiguration> elasticImageConfigurations) {
        HashMultimap vpc2subnet = HashMultimap.create();
        HashSet subnetIds = new HashSet();
        for (ElasticImageConfiguration elasticImageConfiguration : elasticImageConfigurations) {
            Collection imageSubnetIds = elasticImageConfiguration.getSubnetIds();
            if (imageSubnetIds.isEmpty()) {
                VpcId defaultVpc = VpcId.from((String)Ec2AccountAttributes.getDefaultVpc((Map)account.getAccountAttributes()));
                vpc2subnet.put((Object)defaultVpc, (Object)SubnetId.NO_SUBNET);
                continue;
            }
            Iterables.addAll(subnetIds, (Iterable)SubnetId.from((Collection)imageSubnetIds));
        }
        if (!subnetIds.isEmpty()) {
            Collection subnets = account.getSubnetCache().describeResources(subnetIds);
            for (Subnet subnet : subnets) {
                vpc2subnet.put((Object)VpcId.from((String)subnet.getVpcId()), (Object)SubnetId.from((Subnet)subnet));
            }
        }
        return vpc2subnet;
    }

    private synchronized Multimap<SubnetId, SecurityGroupId> ensureSecurityGroupsExist(AWSAccount awsAccount, String securityGroupName, Iterable<ElasticImageConfiguration> elasticImageConfigurations) throws AWSException {
        SecurityGroup newGroup;
        SetMultimap<VpcId, SubnetId> vpcId2subnet = this.getVpcsAndSubnets(awsAccount, Sets.newHashSet(elasticImageConfigurations));
        HashSet netsWithoutLaunchSecurityGroup = new HashSet(vpcId2subnet.keySet());
        HashSet netsWithoutBambooControlTag = Sets.newHashSet(netsWithoutLaunchSecurityGroup);
        ArrayListMultimap securityGroupIdsForSubnets = ArrayListMultimap.create();
        for (SecurityGroup securityGroup : awsAccount.describeSecurityGroups()) {
            boolean shouldProcessControlTagGroup;
            boolean shouldProcessLaunchGroup;
            VpcId vpcId = VpcId.from((String)securityGroup.getVpcId());
            boolean bl = shouldProcessLaunchGroup = securityGroup.getGroupName().equalsIgnoreCase(securityGroupName) && netsWithoutLaunchSecurityGroup.remove(vpcId);
            if (shouldProcessLaunchGroup) {
                boolean isGroupCreatedFromScratch = false;
                this.ensureInboundTrafficIsAllowed(awsAccount, securityGroup, false);
            }
            boolean bl2 = shouldProcessControlTagGroup = securityGroup.getGroupName().equalsIgnoreCase(this.elasticInstanceManager.getBambooControlTag()) && netsWithoutBambooControlTag.remove(vpcId);
            if (!shouldProcessLaunchGroup && !shouldProcessControlTagGroup) continue;
            ElasticFunctionalityFacadeImpl.putAllSubnets((Multimap<SubnetId, SecurityGroupId>)securityGroupIdsForSubnets, vpcId, securityGroup, vpcId2subnet);
        }
        for (VpcId netWithoutLaunchSecurityGroup : netsWithoutLaunchSecurityGroup) {
            log.info((Object)("Creating security group [" + securityGroupName + "] in " + netWithoutLaunchSecurityGroup));
            newGroup = awsAccount.newSecurityGroup(securityGroupName, "Atlassian Bamboo Elastic Agents", netWithoutLaunchSecurityGroup);
            boolean isGroupCreatedFromScratch = true;
            this.ensureInboundTrafficIsAllowed(awsAccount, newGroup, true);
            ElasticFunctionalityFacadeImpl.putAllSubnets((Multimap<SubnetId, SecurityGroupId>)securityGroupIdsForSubnets, netWithoutLaunchSecurityGroup, newGroup, vpcId2subnet);
        }
        for (VpcId netWithoutBambooControlTag : netsWithoutBambooControlTag) {
            log.info((Object)("Creating security group [" + this.elasticInstanceManager.getBambooControlTag() + "] in " + netWithoutBambooControlTag));
            newGroup = awsAccount.newSecurityGroup(this.elasticInstanceManager.getBambooControlTag(), "Instance shutdown controlled by Bamboo", netWithoutBambooControlTag);
            ElasticFunctionalityFacadeImpl.putAllSubnets((Multimap<SubnetId, SecurityGroupId>)securityGroupIdsForSubnets, netWithoutBambooControlTag, newGroup, vpcId2subnet);
        }
        return securityGroupIdsForSubnets;
    }

    private static void putAllSubnets(Multimap<SubnetId, SecurityGroupId> securityGroupIdsForSubnets, VpcId vpcId, SecurityGroup securityGroup, SetMultimap<VpcId, SubnetId> vpcId2subnet) {
        for (SubnetId subnetId : vpcId2subnet.get((Object)vpcId)) {
            securityGroupIdsForSubnets.put((Object)subnetId, (Object)SecurityGroupId.from((SecurityGroup)securityGroup));
        }
    }

    private void ensureInboundTrafficIsAllowed(@NotNull AWSAccount awsAccount, @NotNull SecurityGroup securityGroup, boolean isGroupCreatedFromScratch) {
        boolean shouldCreateTunnelIpv6Rule;
        boolean shouldCreateTunnelIpv4Rule;
        boolean isIpv6Supported = StringUtils.isNotBlank((CharSequence)securityGroup.getVpcId());
        if (isGroupCreatedFromScratch) {
            shouldCreateTunnelIpv4Rule = true;
            shouldCreateTunnelIpv6Rule = true;
        } else {
            boolean hasIpv6Wildcard;
            boolean hasIpv4Wildcard = !EC2Utils.getMatchingIpPermissions((SecurityGroup)securityGroup, (Protocol)Protocol.TCP, (String)ANY_IPV4_ADDRESS, (int)this.elasticInstanceManager.getTunnelPort()).isEmpty();
            boolean bl = hasIpv6Wildcard = !EC2Utils.getMatchingIpPermissions((SecurityGroup)securityGroup, (Protocol)Protocol.TCP, (String)ANY_IPV6_ADDRESS, (int)this.elasticInstanceManager.getTunnelPort()).isEmpty();
            if (hasIpv4Wildcard || hasIpv6Wildcard) {
                shouldCreateTunnelIpv4Rule = !hasIpv4Wildcard;
                shouldCreateTunnelIpv6Rule = !hasIpv6Wildcard;
            } else {
                List ipLockedMatches = EC2Utils.getMatchingIpPermissions((SecurityGroup)securityGroup, (Protocol)Protocol.TCP, null, (int)this.elasticInstanceManager.getTunnelPort());
                boolean isIpLocked = !ipLockedMatches.isEmpty();
                shouldCreateTunnelIpv4Rule = !isIpLocked;
                boolean bl2 = shouldCreateTunnelIpv6Rule = !isIpLocked;
                if (isIpLocked) {
                    List allIpRanges = ipLockedMatches.stream().map(p -> Stream.concat(p.getIpv4Ranges().stream().map(IpRange::getCidrIp), p.getIpv6Ranges().stream().map(Ipv6Range::getCidrIpv6))).flatMap(Function.identity()).collect(Collectors.toList());
                    log.info((Object)("EC2 Tunnel is IP-locked to: " + allIpRanges));
                }
            }
        }
        if (shouldCreateTunnelIpv4Rule) {
            awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV4_ADDRESS, this.elasticInstanceManager.getTunnelPort());
        }
        if (shouldCreateTunnelIpv6Rule && isIpv6Supported) {
            awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV6_ADDRESS, this.elasticInstanceManager.getTunnelPort());
        }
        if (isGroupCreatedFromScratch && securityGroup.getGroupName().equals(ElasticInstanceManager.ELASTIC_BAMBOO_SECURITY_GROUP)) {
            awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV4_ADDRESS, 22);
            awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV4_ADDRESS, 3389);
            if (isIpv6Supported) {
                awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV6_ADDRESS, 22);
                awsAccount.ensureInboundTrafficIsAllowed(securityGroup, Protocol.TCP, ANY_IPV6_ADDRESS, 3389);
            }
        }
    }

    private static boolean areAvailabilityZonesAvailable(@NotNull AWSAccount awsAccount, @NotNull ElasticImageConfiguration elasticImageConfiguration) throws AWSException {
        Collection configuredAzs = elasticImageConfiguration.getAvailabilityZones();
        if (configuredAzs.isEmpty()) {
            return true;
        }
        Map availableAzs = awsAccount.getAvailabilityZones();
        for (String configuredAz : configuredAzs) {
            AvailabilityZone availabilityZone = (AvailabilityZone)availableAzs.get(configuredAz);
            if (availabilityZone == null || !availabilityZone.getState().equalsIgnoreCase(AVAILABILITY_ZONE_STATUS_AVAILABLE)) continue;
            return true;
        }
        return false;
    }

    public boolean isElasticSupportEnabled() {
        ElasticConfiguration elasticConfiguration = this.elasticAccountBean.getElasticConfig();
        return elasticConfiguration != null && elasticConfiguration.isEnabled();
    }

    public boolean isElasticSupportPossible(@NotNull ErrorCollection errorCollection) {
        if (this.bambooLicenseManager.getAllowedNumberOfRemoteAgents() == 0) {
            errorCollection.addErrorMessage(this.textProvider.getText("elastic.configure.licenseForbidsElastic"));
            return false;
        }
        if (!this.remoteAgentManager.isRemoteAgentFunctionEnabled()) {
            String agentsLink = RequestCacheThreadLocal.getRequest().getContextPath() + "/admin/agent/configureAgents!doDefault.action";
            errorCollection.addErrorMessage(this.textProvider.getText("elastic.configure.remoteAgentFunctionDisabled", null, agentsLink));
            return false;
        }
        return true;
    }

    public void setElasticSupportEnabled(boolean elasticSupportEnabled) {
        ElasticConfiguration elasticConfiguration = this.elasticAccountBean.getElasticConfig();
        if (elasticConfiguration != null) {
            if (this.bambooLicenseManager.getAllowedNumberOfRemoteAgents() >= 0 && elasticConfiguration.getMaxConcurrentInstances() > this.bambooLicenseManager.getAllowedNumberOfRemoteAgents()) {
                elasticConfiguration.setMaxConcurrentInstances(this.getMaxConcurrentInstances());
            }
            elasticConfiguration.setEnabled(elasticSupportEnabled);
            this.elasticAccountBean.saveElasticConfig(elasticConfiguration);
        }
    }

    public boolean validateAgentCreation(int numAgentsRequired, ErrorCollection errorCollection) {
        if (!this.isElasticSupportEnabled()) {
            errorCollection.addErrorMessage(this.textProvider.getText("elastic.configure.error.elasticBambooSupportDisabled"));
            return false;
        }
        return this.validateAgentCreationBasedOnLicenseOnly(numAgentsRequired, errorCollection) && this.validateAgentCreationBasedOnElasticSettingsOnly(numAgentsRequired, errorCollection);
    }

    private boolean validateAgentCreationBasedOnElasticSettingsOnly(int numAgentsRequired, ErrorCollection errorCollection) {
        int currentlyRequested;
        ElasticConfiguration elasticConfig = this.elasticAccountBean.getElasticConfig();
        int elasticAgentLimit = elasticConfig.getMaxConcurrentInstances();
        int currentlyRunning = this.elasticInstanceManager.getElasticRemoteAgents().size();
        if (numAgentsRequired + currentlyRunning + (currentlyRequested = this.elasticInstanceManager.getRequestedElasticRemoteAgents().size()) > elasticAgentLimit) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Could not create ");
            if (numAgentsRequired == 1) {
                errorMessage.append("a new elastic agent. ");
            } else {
                errorMessage.append(numAgentsRequired).append(" new elastic agents. ");
            }
            errorMessage.append("The maximum elastic instances configured for Bamboo is ").append(elasticAgentLimit);
            if (currentlyRunning > 0) {
                errorMessage.append(", there is currently ").append(currentlyRunning).append(" instances running");
                if (currentlyRequested > 0) {
                    errorMessage.append(" and ").append(currentlyRequested).append(" instances pending");
                }
            } else if (currentlyRequested > 0) {
                errorMessage.append(", there is currently ").append(currentlyRunning).append(" instances pending");
            }
            errorMessage.append(".");
            errorCollection.addErrorMessage(errorMessage.toString());
            return false;
        }
        return true;
    }

    private boolean validateAgentCreationBasedOnLicenseOnly(int numAgentsRequired, ErrorCollection errorCollection) {
        if (!this.agentManager.allowNewRemoteAgents(numAgentsRequired)) {
            int allowedNumberOfAgents = this.bambooLicenseManager.getAllowedNumberOfRemoteAgents();
            int totalElasticInstances = this.elasticInstanceManager.getTotalNumElasticRemoteAgents();
            int onlineNonElasticRemoteAgents = this.agentManager.getAllRemoteAgents(true).size() - this.agentManager.getOnlineElasticAgents().size();
            int currentRunningAgents = totalElasticInstances + onlineNonElasticRemoteAgents;
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Could not create ");
            if (numAgentsRequired == 1) {
                errorMessage.append("a new elastic agent. ");
            } else {
                errorMessage.append(numAgentsRequired).append(" new elastic agents. ");
            }
            errorMessage.append("Your license only allows ");
            if (allowedNumberOfAgents < 0) {
                errorMessage.append("unlimited remote agents");
            } else if (allowedNumberOfAgents == 1) {
                errorMessage.append("1 remote agent");
            } else {
                errorMessage.append(allowedNumberOfAgents).append(" remote agents");
            }
            if (currentRunningAgents > 0) {
                errorMessage.append(" and there ");
                if (currentRunningAgents == 1) {
                    errorMessage.append("is currently 1 remote agent");
                } else {
                    errorMessage.append("are currently ").append(currentRunningAgents).append(" remote agents");
                }
                errorMessage.append(" online or pending.");
            } else {
                errorMessage.append(".");
            }
            errorCollection.addErrorMessage(errorMessage.toString());
            return false;
        }
        return true;
    }

    public void updateAgentPendingStatus(@NotNull String instanceId) {
        RemoteElasticInstance instance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(instanceId);
        if (instance != null) {
            this.addElasticLogEntry(log, this.textProvider.getText("elastic.configure.message.instanceLoading", new String[]{instanceId}));
            instance.setAgentLoading(true);
        }
    }

    public void addElasticLogEntry(org.apache.log4j.Logger log, String logEntry) {
        this.elasticInstanceManager.addElasticLogEntry(log, logEntry);
    }

    public void addElasticLogEntry(Logger log, String logEntry) {
        this.elasticInstanceManager.addElasticLogEntry(log, logEntry);
    }

    @Transactional
    public void adjustElasticInstanceNumbers(@NotNull ElasticInstanceSchedule instanceSchedule) throws AWSException {
        log.info((Object)("Adjusting elastic agents with schedule: " + instanceSchedule));
        ElasticImageConfiguration imageConfig = instanceSchedule.getElasticImageConfiguration();
        SetMultimap instancesByConfigMultiMap = this.elasticInstanceManager.getAllElasticAgentsAsMap();
        if (imageConfig != null) {
            Set instances = instancesByConfigMultiMap.get((Object)imageConfig);
            this.adjustElasticInstancesForConfig(instanceSchedule, imageConfig, instances);
        } else {
            log.info((Object)"Adjusting all elastic instance...");
            Set entries = instancesByConfigMultiMap.asMap().entrySet();
            for (Map.Entry entry : entries) {
                ElasticImageConfiguration elasticImageConfiguration = (ElasticImageConfiguration)entry.getKey();
                Collection elasticInstanceCollection = (Collection)entry.getValue();
                this.adjustElasticInstancesForConfig(instanceSchedule, elasticImageConfiguration, elasticInstanceCollection);
            }
        }
    }

    private void adjustElasticInstancesForConfig(ElasticInstanceSchedule instanceSchedule, ElasticImageConfiguration imageConfig, Collection<RemoteElasticInstance> instances) throws AWSException {
        int instancesCount = instances.size();
        int adjustmentNumber = instanceSchedule.getNumberToAdjust(instancesCount);
        if (adjustmentNumber > 0) {
            this.startupAgents(imageConfig, adjustmentNumber);
        } else if (adjustmentNumber < 0) {
            this.attemptShutdownInstances(instances, -adjustmentNumber, imageConfig);
        } else {
            log.info((Object)("Image config '" + imageConfig.getConfigurationName() + "' already has " + instancesCount + " instances. "));
        }
    }

    protected void attemptShutdownInstances(Collection<RemoteElasticInstance> instances, int agentsToShutdown, ElasticImageConfiguration elasticImageConfiguration) {
        log.info((Object)("Attempting to shutdown " + agentsToShutdown + " of '" + elasticImageConfiguration.getConfigurationName() + "' elastic instances"));
        int actualAgentsToShutdown = Math.min(instances.size(), agentsToShutdown);
        ArrayList<RemoteElasticInstance> list = new ArrayList<RemoteElasticInstance>(instances);
        list.sort(new ShutdownOrderComparator(this.agentManager));
        for (int i = 0; i < actualAgentsToShutdown; ++i) {
            RemoteElasticInstance remoteElasticInstance = (RemoteElasticInstance)list.get(i);
            BuildAgent buildAgent = this.agentManager.getAgent(remoteElasticInstance.getRemoteAgent());
            if (buildAgent != null && buildAgent.getAgentStatus() instanceof AgentBuildingStatus) {
                this.stopBuildManager.stopAgentNicely(buildAgent);
                continue;
            }
            this.shutdownInstance(remoteElasticInstance);
        }
    }

    private void startupAgents(ElasticImageConfiguration elasticImageConfiguration, int numberOfAgents) throws AWSException {
        log.info((Object)("Starting up " + numberOfAgents + " of '" + elasticImageConfiguration.getConfigurationName() + "' elastic instances"));
        List<ElasticImageConfiguration> elasticImageConfigurations = Collections.nCopies(numberOfAgents, elasticImageConfiguration);
        this.startupAgents(elasticImageConfigurations);
    }

    public int getMaxConcurrentInstances() {
        int allowedAgents = this.bambooLicenseManager.getAllowedNumberOfRemoteAgents();
        if (allowedAgents < 0) {
            return 5;
        }
        return Math.min(allowedAgents, 5);
    }

    @NotNull
    public String getPkFileLocation() {
        return this.ec2PrivateKeyHandler.getUnvalidatedPrivateKeyLocation().getAbsolutePath();
    }

    @NotNull
    public Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, File> getPrivateKeyLocation() {
        return this.ec2PrivateKeyHandler.getPrivateKeyLocation();
    }

    @NotNull
    public Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, Optional<String>> getPassword(RemoteElasticInstance instance) {
        return this.ec2PrivateKeyHandler.getPassword(instance);
    }

    @NotNull
    public String getKeyPairName() {
        return ElasticInstanceManager.ELASTIC_BAMBOO_KEY_PAIR;
    }

    public void cleanupCredentials() {
        ElasticConfiguration elasticConfiguration = this.elasticAccountBean.getElasticConfig();
        if (elasticConfiguration != null) {
            elasticConfiguration.setAwsAccessKeyId("");
            elasticConfiguration.setAwsSecretKey("");
            elasticConfiguration.setEnabled(false);
            this.elasticAccountBean.saveElasticConfig(elasticConfiguration);
        }
    }
}

