/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.event.elastic.ElasticImageFailedToStartEvent;
import com.atlassian.event.api.EventPublisher;
import org.apache.log4j.Logger;

public class ElasticInstanceManagementListener
implements RemoteElasticInstanceListener {
    private static final Logger log = Logger.getLogger(ElasticInstanceManagementListener.class);
    private final ElasticInstanceManager elasticInstanceManager;
    private final EventPublisher eventPublisher;

    public ElasticInstanceManagementListener(ElasticInstanceManager elasticInstanceManager, EventPublisher eventPublisher) {
        this.elasticInstanceManager = elasticInstanceManager;
        this.eventPublisher = eventPublisher;
    }

    public void elasticInstanceStateChanged(RemoteElasticInstance remoteElasticInstance, RemoteElasticInstanceState oldState, RemoteElasticInstanceState newState) {
        String logEntry;
        String sensibleId;
        RemoteEC2Instance instance = remoteElasticInstance.getInstance();
        String string = sensibleId = instance != null ? instance.getInstanceStatus().getSensibleId() : null;
        if (sensibleId != null && newState != RemoteElasticInstanceState.BIDDING) {
            logEntry = "Elastic instance [" + sensibleId + "] transitioned from " + oldState + " to " + newState + ".";
            this.elasticInstanceManager.addElasticLogEntry(log, logEntry);
        }
        if (newState.isFinal()) {
            if (sensibleId != null) {
                logEntry = "Detected that the elastic instance [" + sensibleId + "] has been terminated.";
            } else {
                logEntry = "Detected that a pending instance request for image [" + remoteElasticInstance.getConfiguration().getConfigurationName() + "], ami: " + remoteElasticInstance.getConfiguration().getAmiId() + " has been abandoned.";
                this.eventPublisher.publish((Object)new ElasticImageFailedToStartEvent(remoteElasticInstance.getConfiguration().getId()));
            }
            this.elasticInstanceManager.addElasticLogEntry(log, logEntry);
            this.elasticInstanceManager.registerElasticAgentStopped(remoteElasticInstance);
        } else {
            switch (newState) {
                case BIDDING: {
                    this.elasticInstanceManager.addElasticLogEntry(log, "Spot Instance request [" + sensibleId + "] has been placed.");
                    break;
                }
                case IDENTIFIED: {
                    this.elasticInstanceManager.onInstanceIdentified(remoteElasticInstance);
                    break;
                }
                case RUNNING: {
                    this.elasticInstanceManager.onInstanceRunning(remoteElasticInstance);
                }
            }
        }
    }
}

