/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.credentials.StaticAWSCredentials;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.InstanceLaunchConfigurationBuilder;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.ElasticResourceNamingHelper;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceImpl;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.tunnel.DefaultElasticAgentTunnelManagerFactory;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelManager;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelPorts;
import com.atlassian.bamboo.agent.elastic.tunnel.SSLContextFactory;
import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.ElasticTunnelDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.cluster.state.Stateful;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.security.KeyStoreFactory;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Stateful
public class ElasticInstanceManagerImpl
implements ElasticInstanceManager {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ElasticInstanceManagerImpl.class);
    private static final int DEFAULT_TUNNEL_PORT = 26224;
    private static final int DEFAULT_HTTP_PROXY_PORT = 46593;
    private static final int DEFAULT_JMS_PROXY_PORT = 4527;
    private static final int ELASTIC_AGENT_LOG_SIZE = 30;
    private static final Set<EC2InstanceType> ALLOWED_INSTANCE_TYPES = EnumSet.allOf(EC2InstanceType.class);
    @VisibleForTesting
    static final String DEFAULT_CONTROL_TAG = "ControlledByBamboo";
    private final Collection<String> elasticAgentLog = Queues.synchronizedQueue((Queue)new CircularFifoQueue(30));
    private int tunnelTimeoutMinutes = -1;
    private final LoadingCache<String, String> instanceLogCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).softValues().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@NotNull String instanceId) {
            String consoleOutput = ElasticInstanceManagerImpl.this.awsAccountBean.getAwsAccount().getConsoleOutput(instanceId);
            return StringUtils.right((String)consoleOutput, (int)65536);
        }
    });
    private final String bambooControlTag = System.getProperties().getProperty("bamboo.ec2.instance.filters", "ControlledByBamboo");
    RequestedAndRunningInstances instances = new RequestedAndRunningInstances();
    private final AwsAccountBean awsAccountBean;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final int startupTimeoutSeconds;
    private final ScheduledExecutorService executor;
    private final KeyStoreFactory keyStoreFactory;
    private final SSLContextFactory sslContextFactory;
    private final BootstrapManager bootstrapManager;
    private final ErrorHandler errorHandler;
    private final SpotInstanceConfigurationAccessor spotInstanceConfigurationAccessor;
    private final EventPublisher eventPublisher;
    private final SecretEncryptionService secretEncryptionService;
    @Autowired
    private BambooBrokerService brokerService;

    public ElasticInstanceManagerImpl(AwsAccountBean awsAccountBean, AdministrationConfigurationAccessor administrationConfigurationAccessor, int startupTimeoutSeconds, ScheduledExecutorService executor, KeyStoreFactory keyStoreFactory, SSLContextFactory sslContextFactory, BootstrapManager bootstrapManager, ErrorHandler errorHandler, SpotInstanceConfigurationAccessor spotInstanceConfigurationAccessor, EventPublisher eventPublisher, SecretEncryptionService secretEncryptionService) {
        this.awsAccountBean = awsAccountBean;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        this.executor = executor;
        this.keyStoreFactory = keyStoreFactory;
        this.sslContextFactory = sslContextFactory;
        this.bootstrapManager = bootstrapManager;
        this.errorHandler = errorHandler;
        this.spotInstanceConfigurationAccessor = spotInstanceConfigurationAccessor;
        this.eventPublisher = eventPublisher;
        this.secretEncryptionService = secretEncryptionService;
    }

    private RemoteElasticInstanceImpl createRemoteElasticInstanceObject(RemoteElasticInstanceListener listener, AWSAccount awsAccount, @NotNull AgentManager agentManager, @NotNull ElasticImageConfiguration elasticImageConfiguration, @NotNull InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder, @Nullable KeyStore keyStoreArg) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, UnrecoverableKeyException, KeyStoreException {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String baseUrlToUseForAgents = SystemProperty.EC2_AGENT_ENDPOINT.getValue(administrationConfiguration.getBaseUrl());
        String agentServerUrlString = baseUrlToUseForAgents + "/agentServer/";
        URL agentServerUrl = new URL(agentServerUrlString);
        char[] pass = "bamboo".toCharArray();
        KeyStore keyStore = keyStoreArg != null ? keyStoreArg : this.keyStoreFactory.generateKeyStore("elastic", agentServerUrlString, pass, pass);
        SSLContext sslContext = this.sslContextFactory.newSSLContext(keyStore);
        ElasticAgentTunnelManager tunnelManager = DefaultElasticAgentTunnelManagerFactory.INSTANCE.create(agentServerUrl, sslContext, this.brokerService, (ElasticAgentTunnelPorts)this);
        RemoteElasticInstanceImpl remoteElasticAgent = new RemoteElasticInstanceImpl(this, tunnelManager, this.errorHandler, awsAccount, agentServerUrl, this.startupTimeoutSeconds, listener, this.executor, keyStore, administrationConfiguration.getElasticConfig(), agentManager, elasticImageConfiguration, instanceLaunchConfigurationBuilder, this.spotInstanceConfigurationAccessor.getSpotInstanceConfig(), this.bootstrapManager.getFingerprint(), this.eventPublisher, this.secretEncryptionService);
        if (this.tunnelTimeoutMinutes > 0) {
            remoteElasticAgent.setTunnelTimeoutMinutes(this.tunnelTimeoutMinutes);
        }
        return remoteElasticAgent;
    }

    public RemoteElasticInstance newElasticAgent(RemoteElasticInstanceListener listener, AWSAccount awsAccount, @NotNull AgentManager agentManager, @NotNull ElasticImageConfiguration elasticImageConfiguration, @NotNull InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, UnrecoverableKeyException, KeyStoreException {
        RemoteElasticInstanceImpl remoteElasticAgent = this.createRemoteElasticInstanceObject(listener, awsAccount, agentManager, elasticImageConfiguration, instanceLaunchConfigurationBuilder, null);
        this.instances.addToRequestedInstances(remoteElasticAgent);
        return remoteElasticAgent;
    }

    public RemoteElasticInstance restoreElasticAgent(@NotNull ElasticAgentDefinition elasticAgentDefinition, @Nullable ElasticTunnelDefinition elasticTunnelDefinition, @NotNull Instance instance, @NotNull RemoteElasticInstanceListener listener, @NotNull AWSAccount awsAccount, @NotNull AgentManager agentManager, @NotNull InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder) throws Exception {
        KeyStore keyStore = elasticTunnelDefinition != null ? elasticTunnelDefinition.getKeyStore(this.secretEncryptionService) : null;
        RemoteElasticInstanceImpl remoteElasticAgent = this.createRemoteElasticInstanceObject(listener, awsAccount, agentManager, elasticAgentDefinition.getElasticImageConfiguration(), instanceLaunchConfigurationBuilder, keyStore);
        remoteElasticAgent.restoreInstance(elasticAgentDefinition, instance);
        this.instances.transitionToRunning(remoteElasticAgent);
        return remoteElasticAgent;
    }

    public void ensureLoginKeyPairExists(AWSAccount awsAccount, String keyPair) throws AWSException {
        block5: {
            try {
                Map keyPairs = awsAccount.describeEc2KeyPairs(new String[]{keyPair});
                if (keyPairs.containsKey(keyPair)) {
                    return;
                }
            }
            catch (AmazonServiceException e) {
                if (AmazonServiceErrorCode.INVALID_KEYPAIR_NOT_FOUND.is(e)) break block5;
                throw e;
            }
        }
        log.info((Object)("EC2 keypair for '" + keyPair + "' not found. Generating a new keypair..."));
        try {
            KeyPair privateKey = awsAccount.newEC2KeyPair(keyPair);
            File privateKeyFile = new File(this.bootstrapManager.getConfigDirectory(), ELASTIC_BAMBOO_KEY_PAIR_FILE);
            log.info((Object)("Writing to private key to " + privateKeyFile.getAbsolutePath()));
            FileUtils.writeStringToFile((File)privateKeyFile, (String)privateKey.getKeyMaterial(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String message = "Unable to write to file " + ELASTIC_BAMBOO_KEY_PAIR_FILE;
            log.error((Object)message, (Throwable)e);
            throw new AWSException(message, (Throwable)e);
        }
    }

    public boolean validateAwsCredentials(AwsSupportConstants.Region region, String awsAccessID, String awsSecretKey, ErrorCollection errorCollection) {
        StaticAWSCredentials awsCredentials = new StaticAWSCredentials(awsAccessID, awsSecretKey);
        return this.validateAwsCredentials(region, (AWSCredentials)awsCredentials, errorCollection);
    }

    public boolean validateAwsCredentials(AwsSupportConstants.Region region, AWSCredentials awsCredentials, ErrorCollection errorCollection) {
        String errorMessage;
        try {
            errorMessage = this.awsAccountBean.getAccountDetailsValidationError(region, awsCredentials);
        }
        catch (AWSException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            if (errorCollection != null) {
                errorCollection.addErrorMessage("A communication error occurred while trying to validate the AWS account credentials.", (Exception)((Object)exception));
            }
            return false;
        }
        if (errorMessage != null && errorCollection != null) {
            errorCollection.addErrorMessage("The supplied AWS account credentials are either not valid or cannot be used to access EC2 services. The error message was: " + errorMessage);
        }
        return errorMessage == null;
    }

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgents() {
        return this.instances.getRunningInstances();
    }

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        return this.getElasticRemoteAgentsByConfiguration(elasticImageConfiguration.getId());
    }

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(long id) {
        return this.getElasticRemoteAgents().stream().filter(remoteElasticInstance -> remoteElasticInstance.getConfiguration().getId() == id).collect(Collectors.toList());
    }

    @Nullable
    public RemoteElasticInstance getElasticRemoteAgentByInstanceId(String instanceId) {
        return this.instances.get(instanceId);
    }

    @NotNull
    public List<RemoteElasticInstance> getRequestedElasticRemoteAgents() {
        return this.instances.getRequestedInstances();
    }

    @NotNull
    public List<RemoteElasticInstance> getStartingElasticInstances() {
        return this.getElasticRemoteAgents().stream().filter(remoteElasticInstance -> remoteElasticInstance.getState() == RemoteElasticInstanceState.IDENTIFIED).collect(Collectors.toList());
    }

    @NotNull
    public List<RemoteElasticInstance> getInstancesWithStartingAgents() {
        return this.getElasticRemoteAgents().stream().filter(RemoteElasticInstance::isAgentLoading).collect(Collectors.toList());
    }

    public List<RemoteElasticInstance> getAllElasticRemoteAgents() {
        return this.instances.getAllInstances();
    }

    public SetMultimap<ElasticImageConfiguration, RemoteElasticInstance> getAllElasticAgentsAsMap() {
        List<RemoteElasticInstance> elasticInstances = this.getAllElasticRemoteAgents();
        HashMultimap amiIdToInstancesMap = HashMultimap.create();
        for (RemoteElasticInstance elasticInstance : elasticInstances) {
            amiIdToInstancesMap.put((Object)elasticInstance.getConfiguration(), (Object)elasticInstance);
        }
        return amiIdToInstancesMap;
    }

    public int getTotalNumElasticRemoteAgents() {
        return this.instances.getInstancesCount();
    }

    public void onInstanceIdentified(@NotNull RemoteElasticInstance instance) {
        this.registerElasticInstanceStarted(instance);
    }

    public void onInstanceRunning(@NotNull RemoteElasticInstance instance) {
        if (instance.getInstance().getInstanceStatus().getSpotInstanceRequestId() != null) {
            this.tagInstance(instance);
        }
    }

    public boolean cancelSpotRequests(@NotNull AWSAccount awsAccount) {
        boolean atLeastOneRequestWasCancelled = false;
        for (SpotInstanceRequest spotInstanceRequest : awsAccount.describePendingSpotInstanceRequests(new String[0])) {
            for (GroupIdentifier groupIdentifier : spotInstanceRequest.getLaunchSpecification().getAllSecurityGroups()) {
                if (!this.bambooControlTag.equals(groupIdentifier.getGroupName())) continue;
                String spotInstanceRequestId = spotInstanceRequest.getSpotInstanceRequestId();
                log.info((Object)("Cancelling spot request: " + spotInstanceRequestId));
                awsAccount.cancelSpotInstanceRequests(new String[]{spotInstanceRequestId});
                atLeastOneRequestWasCancelled = true;
            }
        }
        return atLeastOneRequestWasCancelled;
    }

    private void tagInstance(RemoteElasticInstance instance) {
        RemoteEC2Instance awsInstance = instance.getInstance();
        String tagName = ElasticResourceNamingHelper.getInstanceTag();
        try {
            awsInstance.addTag("Name", tagName);
        }
        catch (AmazonClientException e) {
            log.warn((Object)("Unable to tag instance " + awsInstance.getInstanceId() + ", reason: " + e.toString()));
        }
    }

    private boolean registerElasticInstanceStarted(@NotNull RemoteElasticInstance instance) {
        boolean isAgentRegistrationAccepted = true;
        ElasticConfiguration elasticConfig = this.getElasticConfig();
        if (elasticConfig == null || !elasticConfig.isEnabled()) {
            String message = "Elastic Instance " + instance.getInstance().getInstanceId() + " is trying to start up but Elastic Bamboo has been disabled or no Configuration details could be found.  Instance will be terminated.";
            log.error((Object)message);
            this.addElasticLogEntry(log, message);
            instance.terminate();
            isAgentRegistrationAccepted = false;
        } else if (this.instances.getRunningInstancesCount() >= elasticConfig.getMaxConcurrentInstances()) {
            String message = "Elastic Instance " + instance.getInstance().getInstanceId() + " is trying to start up but the maximum number of Elastic Instances has been reached.  Instance will be terminated.";
            log.error((Object)message);
            this.addElasticLogEntry(log, message);
            instance.terminate();
            isAgentRegistrationAccepted = false;
        }
        this.instances.transitionToRunning(instance);
        return isAgentRegistrationAccepted;
    }

    public void registerElasticAgentStopped(@NotNull RemoteElasticInstance instance) {
        this.instances.remove(instance);
    }

    public void addElasticLogEntry(org.apache.log4j.Logger log, String logEntry) {
        log.info((Object)logEntry);
        this.elasticAgentLog.add(DateFormat.getDateTimeInstance().format(new Date()) + "  " + logEntry);
    }

    public void addElasticLogEntry(Logger log, String logEntry) {
        log.info(logEntry);
        this.elasticAgentLog.add(DateFormat.getDateTimeInstance().format(new Date()) + "  " + logEntry);
    }

    public List<String> getElasticAgentLogs() {
        return Lists.newArrayList((Object[])this.elasticAgentLog.toArray(new String[0]));
    }

    public boolean isElasticSupportEnabled() {
        ElasticConfiguration elasticConfiguration = this.getElasticConfig();
        return elasticConfiguration != null && elasticConfiguration.isEnabled();
    }

    @NotNull
    public Set<EC2InstanceType> getAllowedInstanceTypes() {
        return ALLOWED_INSTANCE_TYPES;
    }

    public int getTunnelPort() {
        return (int)new SystemProperty.IntegerSystemProperty(false, 26224L, new String[]{"elastic.bamboo.tunnel.port"}).getTypedValue();
    }

    public int getAgentSideHttpPort() {
        return (int)new SystemProperty.IntegerSystemProperty(false, 46593L, new String[]{"elastic.bamboo.http.proxy.port"}).getTypedValue();
    }

    public int getAgentSideJmsPort() {
        return (int)new SystemProperty.IntegerSystemProperty(false, 4527L, new String[]{"elastic.bamboo.jms.proxy.port"}).getTypedValue();
    }

    public void setTunnelTimeoutMinutes(int tunnelTimeoutMinutes) {
        this.tunnelTimeoutMinutes = tunnelTimeoutMinutes;
    }

    @NotNull
    public String getInstanceLogs(@NotNull String instanceId) throws AWSException {
        try {
            return (String)this.instanceLogCache.get((Object)instanceId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AWSException) {
                throw (AWSException)e.getCause();
            }
            throw new RuntimeException("Unknown exception occurred while fetching logs for instance: " + instanceId, e);
        }
    }

    public boolean isInstanceKnown(@NotNull String instanceId) {
        return this.getAllElasticRemoteAgents().stream().anyMatch(remoteElasticInstance -> instanceId.equals(remoteElasticInstance.getInstance().getInstanceId()));
    }

    public String getBambooControlTag() {
        return this.bambooControlTag;
    }

    @Nullable
    private ElasticConfiguration getElasticConfig() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
    }

    @Stateful
    private static class RequestedAndRunningInstances {
        private final List<RemoteElasticInstance> requestedInstances = new CopyOnWriteArrayList<RemoteElasticInstance>();
        private final Map<String, RemoteElasticInstance> runningInstances = new ConcurrentHashMap<String, RemoteElasticInstance>();

        private RequestedAndRunningInstances() {
        }

        public List<RemoteElasticInstance> getRunningInstances() {
            return new ArrayList<RemoteElasticInstance>(this.runningInstances.values());
        }

        public RemoteElasticInstance get(String instanceId) {
            return this.runningInstances.get(instanceId);
        }

        public List<RemoteElasticInstance> getRequestedInstances() {
            return new ArrayList<RemoteElasticInstance>(this.requestedInstances);
        }

        public synchronized List<RemoteElasticInstance> getAllInstances() {
            ArrayList<RemoteElasticInstance> elasticInstances = new ArrayList<RemoteElasticInstance>(this.requestedInstances);
            elasticInstances.addAll(this.runningInstances.values());
            return elasticInstances;
        }

        public synchronized int getInstancesCount() {
            return this.requestedInstances.size() + this.runningInstances.size();
        }

        public int getRunningInstancesCount() {
            return this.runningInstances.size();
        }

        private void addToRequestedInstances(RemoteElasticInstanceImpl instance) {
            log.debug((Object)("Instance 0x" + Integer.toHexString(instance.hashCode()) + " added to requested instances"));
            this.requestedInstances.add(instance);
        }

        private void remove(RemoteElasticInstance instance) {
            if (this.requestedInstances.remove(instance)) {
                log.debug((Object)("Instance 0x" + Integer.toHexString(instance.hashCode()) + " removed from requested instances"));
            } else {
                RemoteEC2Instance ec2Instance = instance.getInstance();
                if (ec2Instance != null && this.runningInstances.remove(ec2Instance.getInstanceId()) != null) {
                    log.debug((Object)("Instance 0x" + Integer.toHexString(instance.hashCode()) + " removed from running instances"));
                }
            }
        }

        private synchronized void transitionToRunning(RemoteElasticInstance instance) {
            this.requestedInstances.remove(instance);
            String instanceId = instance.getInstance().getInstanceId();
            if (instanceId != null) {
                this.runningInstances.put(instanceId, instance);
                log.debug((Object)("Instance 0x" + Integer.toHexString(instance.hashCode()) + " with id " + instanceId + " moved to running instances"));
            } else {
                log.error((Object)("Elastic Agent " + instance + " is trying to register with no instance ID"));
            }
        }
    }
}

