/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import java.util.Comparator;
import java.util.Date;

public class RemoteElasticAgentStartTimeComparator
implements Comparator<RemoteElasticInstance> {
    private static final Comparator<Date> LAUNCH_TIME_COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());
    private static final Comparator<RemoteEC2Instance> REMOTE_EC_2_INSTANCE_COMPARATOR = Comparator.nullsLast(Comparator.comparing(instance -> instance.getInstanceStatus().getLaunchTime(), LAUNCH_TIME_COMPARATOR));
    private static final Comparator<RemoteElasticInstance> REMOTE_ELASTIC_INSTANCE_COMPARATOR = Comparator.nullsLast(Comparator.comparing(RemoteElasticInstance::getInstance, REMOTE_EC_2_INSTANCE_COMPARATOR));

    @Override
    public int compare(RemoteElasticInstance agent1, RemoteElasticInstance agent2) {
        return REMOTE_ELASTIC_INSTANCE_COMPARATOR.compare(agent1, agent2);
    }
}

