/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.Image;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceEbsHelper;
import com.atlassian.bamboo.util.Narrow;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoteElasticInstanceEbsHelperImpl
implements RemoteElasticInstanceEbsHelper {
    private static final Logger log = Logger.getLogger(RemoteElasticInstanceEbsHelperImpl.class);
    private final AWSAccount awsAccount;
    private final ElasticImageConfiguration elasticImageConfiguration;
    private final Collection<Pair<String, Boolean>> ebsVolumeData = new ArrayList<Pair<String, Boolean>>();
    private boolean volumesCreated;

    RemoteElasticInstanceEbsHelperImpl(AWSAccount awsAccount, ElasticImageConfiguration elasticImageConfiguration) {
        this.awsAccount = awsAccount;
        this.elasticImageConfiguration = elasticImageConfiguration;
        log.info((Object)"Running non-BDM EBS handling code");
    }

    @Override
    public void createEbsVolumesIfNeeded(RemoteEC2Instance ec2Instance) {
        if (this.volumesCreated) {
            return;
        }
        this.volumesCreated = true;
        try {
            this.createEbsVolumes(ec2Instance, this.ebsVolumeData);
        }
        catch (RuntimeException e) {
            this.tearDownVolumes();
            throw e;
        }
    }

    private void createEbsVolumes(RemoteEC2Instance ec2Instance, @NotNull Collection<Pair<String, Boolean>> volumes) {
        boolean deleteOnTermination;
        String volumeId;
        InstanceStatus instanceStatus = ec2Instance.getInstanceStatus();
        String snapshotOrVolumeId = this.elasticImageConfiguration.getEbsSnapshotId();
        if (snapshotOrVolumeId == null) {
            return;
        }
        if (RemoteElasticInstanceEbsHelperImpl.isSnapshot(snapshotOrVolumeId)) {
            volumeId = this.awsAccount.createVolume(snapshotOrVolumeId, instanceStatus.getAvailabilityZone());
            deleteOnTermination = true;
            log.info((Object)("Created volume " + volumeId + " for " + instanceStatus.getInstanceId()));
        } else {
            volumeId = snapshotOrVolumeId;
            deleteOnTermination = false;
        }
        volumes.add((Pair<String, Boolean>)Pair.pair((Object)volumeId, (Object)deleteOnTermination));
    }

    static boolean isSnapshot(@Nullable String snapshotOrVolumeId) {
        return StringUtils.startsWith((CharSequence)snapshotOrVolumeId, (CharSequence)"snap-");
    }

    @Override
    public void attachEbsVolumes(@NotNull RemoteEC2Instance ec2Instance) {
        for (Pair<String, Boolean> volumeIdAndDeleteOnTerminationFlag : this.ebsVolumeData) {
            InstanceStatus instanceStatus = ec2Instance.getInstanceStatus();
            String volumeId = (String)volumeIdAndDeleteOnTerminationFlag.left();
            boolean deleteOnTermination = (Boolean)volumeIdAndDeleteOnTerminationFlag.right();
            String instanceId = instanceStatus.getInstanceId();
            this.awsAccount.attachVolume(volumeId, instanceId, EC2Utils.getEbsDeviceName((Image)this.getImage(this.elasticImageConfiguration)), deleteOnTermination);
            log.info((Object)("Attached " + volumeId + " to instance " + instanceId));
        }
    }

    @Override
    public void tearDownVolumes() {
        for (Pair<String, Boolean> volumeIdAndDeleteOnTerminationFlag : this.ebsVolumeData) {
            Boolean deleteOnTermination = (Boolean)volumeIdAndDeleteOnTerminationFlag.right();
            if (!deleteOnTermination.booleanValue()) continue;
            String volumeId = (String)volumeIdAndDeleteOnTerminationFlag.left();
            try {
                this.awsAccount.deleteVolume(volumeId);
            }
            catch (AWSException e) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)((Object)Narrow.reinterpret((Object)e.getCause(), AmazonServiceException.class));
                if (amazonServiceException != null && AmazonServiceErrorCode.INVALID_VOLUME_NOT_FOUND.is(amazonServiceException)) {
                    log.info((Object)("Volume " + volumeId + " not found, it has probably been automatically deleted"));
                    continue;
                }
                log.warn((Object)"", (Throwable)e);
            }
        }
        this.ebsVolumeData.clear();
    }

    private Image getImage(ElasticImageConfiguration elasticImageConfiguration) {
        return this.awsAccount.describeImage(elasticImageConfiguration.getAmiId());
    }
}

