/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EBSVolume;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceState;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfigurationBuilder;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.SpotPriceMatrix;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataImpl;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataMetadataHelper;
import com.atlassian.bamboo.agent.elastic.server.AwsCredentialsType;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationCapabilities;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageFilesCapabilitiesHelper;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceEbsHelper;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceEbsHelperImpl;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfig;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelManager;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.core.Script;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.event.elastic.ElasticImageFailedToStartEvent;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tunnel.tunnel.client.Tunnel;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteElasticInstanceImpl
implements RemoteElasticInstance {
    private static final Logger log = Logger.getLogger(RemoteElasticInstanceImpl.class);
    private static final String META_AWS_ACCOUNT_PRIVATE_KEY = "aws.accountPrivateKey";
    private static final String META_AWS_ACCOUNT_CERTIFICATE = "aws.accountCert";
    private static final String META_AWS_EBS_SNAPSHOT_ID = "aws.ebs.snapshotId";
    private static final String META_AWS_EBS_DEVICE = "aws.ebs.device.0";
    private static final String META_AWS_STARTED_FROM_BAMBOO = "aws.startedFromBamboo";
    private static final String META_AWS_BAMBOO_SERVER_VERSION = "aws.bambooServerVersion";
    private final ElasticInstanceManager manager;
    private final ElasticAgentTunnelManager tunnelManager;
    private final ServerFingerprint fingerprint;
    private final ErrorHandler errorHandler;
    private final AWSAccount awsAccount;
    private final int startupTimeoutSeconds;
    private final URL baseURL;
    private final RemoteElasticInstanceListener listener;
    private final ScheduledExecutorService executor;
    private final KeyStore keyStore;
    private final ElasticConfiguration elasticConfiguration;
    private volatile RemoteEC2Instance ec2Instance;
    private volatile Collection<Tunnel> tunnels;
    private static final int DEFAULT_TUNNEL_TIMEOUT = 40;
    private int tunnelTimeoutMinutes = 40;
    private final AtomicReference<RemoteElasticInstanceState> state = new AtomicReference<RemoteElasticInstanceState>(RemoteElasticInstanceState.INITIAL);
    private final AgentManager agentManager;
    private final EventPublisher eventPublisher;
    private final SecretEncryptionService secretEncryptionService;
    private final ElasticImageConfiguration elasticImageConfiguration;
    private final InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder;
    private final SpotInstanceConfig spotInstanceConfig;
    private static final Set<RemoteElasticInstanceState> SHUTDOWNABLE_STATES = EnumSet.of(RemoteElasticInstanceState.STARTING, RemoteElasticInstanceState.IDENTIFIED, RemoteElasticInstanceState.RUNNING, RemoteElasticInstanceState.STOPPED, RemoteElasticInstanceState.UNKNOWN);
    private volatile long agentId;
    private volatile boolean agentLoading;
    private final Starter starter = new Starter();
    private final Object scheduledTerminationLock = new Object();
    @GuardedBy(value="scheduledTerminationLock")
    private ScheduledFuture<?> scheduledTerminationFuture;

    public long getRemoteAgent() {
        return this.agentId;
    }

    public void setRemoteAgent(long agentId) {
        this.agentId = agentId;
    }

    public boolean isShutdownable() {
        return SHUTDOWNABLE_STATES.contains(this.getState());
    }

    public boolean isBeingTerminated() {
        return this.ec2Instance.isBeingTerminated();
    }

    public boolean isAgentLoading() {
        return this.agentLoading;
    }

    public void setAgentLoading(boolean agentLoading) {
        this.agentLoading = agentLoading;
    }

    private void putForLogging(@NotNull Map<String, String> map, @NotNull String key, @Nullable Object value) {
        map.put(key, Optional.ofNullable(value).flatMap(OptionalNarrow.downTo(NameProvider.class)).map(NameProvider::getName).orElseGet(() -> Optional.ofNullable(value).map(Object::toString).map(string -> string.isEmpty() ? "<empty>" : string).orElse("<null>")));
    }

    private void logElasticImageConfiguration(@NotNull Level logLevel, @NotNull ElasticImageConfiguration elasticImageConfiguration) {
        if (log.isEnabledFor((Priority)logLevel)) {
            HashMap<String, String> configToLog = new HashMap<String, String>();
            this.putForLogging(configToLog, "amiId", elasticImageConfiguration.getAmiId());
            this.putForLogging(configToLog, "availabilityZones", elasticImageConfiguration.getAvailabilityZones());
            this.putForLogging(configToLog, "ebsSnapshotId", elasticImageConfiguration.getEbsSnapshotId());
            this.putForLogging(configToLog, "configurationName", elasticImageConfiguration.getConfigurationName());
            this.putForLogging(configToLog, "region", elasticImageConfiguration.getRegion());
            this.putForLogging(configToLog, "subnetIds", elasticImageConfiguration.getSubnetIds());
            this.putForLogging(configToLog, "rootDeviceType", elasticImageConfiguration.getRootDeviceType());
            this.putForLogging(configToLog, "architecture", elasticImageConfiguration.getArchitecture());
            this.putForLogging(configToLog, "configurationDescription", elasticImageConfiguration.getConfigurationDescription());
            this.putForLogging(configToLog, "imageFileVersion", elasticImageConfiguration.getImageFilesVersion());
            this.putForLogging(configToLog, "instanceTypes", BambooIterables.stream((Iterable)elasticImageConfiguration.getInstanceTypes()).map(EC2InstanceType::getName).collect(Collectors.toList()));
            this.putForLogging(configToLog, "osName", elasticImageConfiguration.getOsName());
            this.putForLogging(configToLog, "platform", elasticImageConfiguration.getPlatform());
            this.putForLogging(configToLog, "product", elasticImageConfiguration.getProduct());
            this.putForLogging(configToLog, "id", elasticImageConfiguration.getId());
            configToLog.forEach((key, value) -> log.log((Priority)logLevel, (Object)String.format("    %s: %s", key, value)));
        }
    }

    private void logElasticConfiguration(@NotNull Level logLevel, @NotNull ElasticConfiguration elasticConfiguration) {
        if (log.isEnabledFor((Priority)logLevel)) {
            HashMap<String, String> configToLog = new HashMap<String, String>();
            this.putForLogging(configToLog, "awsCertFileConfigured", StringUtils.isNotEmpty((CharSequence)elasticConfiguration.getAwsCertFile()));
            this.putForLogging(configToLog, "awsPrivateKeyFileConfigured", StringUtils.isNotEmpty((CharSequence)elasticConfiguration.getAwsPrivateKeyFile()));
            this.putForLogging(configToLog, "uploadingOfAwsAccountDetailsEnabled", elasticConfiguration.isUploadingOfAwsAccountDetailsEnabled());
            this.putForLogging(configToLog, "autoShutdownEnabled", elasticConfiguration.isAutoShutdownEnabled());
            this.putForLogging(configToLog, "enabled", elasticConfiguration.isEnabled());
            this.putForLogging(configToLog, "maxConcurrentInstances", elasticConfiguration.getMaxConcurrentInstances());
            this.putForLogging(configToLog, "autoShutdownDelay", elasticConfiguration.getAutoShutdownDelay());
            this.putForLogging(configToLog, "region", elasticConfiguration.getRegion());
            configToLog.forEach((key, value) -> log.log((Priority)logLevel, (Object)String.format("    %s: %s", key, value)));
        }
    }

    private void initEc2InstanceObject() throws IOException {
        boolean useBdmForEbs;
        log.debug((Object)"Preparing EC2 instance data");
        log.trace((Object)"Elastic image configuration:");
        this.logElasticImageConfiguration(Level.TRACE, this.elasticImageConfiguration);
        log.trace((Object)"Elastic Bamboo configuration:");
        this.logElasticConfiguration(Level.TRACE, this.elasticConfiguration);
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(META_AWS_STARTED_FROM_BAMBOO, "true");
        metaData.put(META_AWS_BAMBOO_SERVER_VERSION, BuildUtils.getCurrentVersion());
        ElasticAgentUserDataMetadataHelper.setFingerprint(metaData, (String)this.fingerprint.getServerFingerprint());
        this.addAssemblyLocation(metaData, this.elasticImageConfiguration.getRegion());
        this.addToMetaDataIfExists(metaData, SystemProperty.ELASTIC_AGENT_LOG_AWS_SECRET);
        this.addToMetaDataIfExists(metaData, SystemProperty.ELASTIC_AGENT_LOG_AWS_ID);
        if (this.elasticConfiguration.isUploadingOfAwsAccountDetailsEnabled()) {
            this.attachAccountDetails(metaData);
        } else {
            log.debug((Object)"Uploading of AWS account details is disabled");
        }
        ElasticAgentUserDataMetadataHelper.setInstallerRunCommand(metaData, (Iterable)this.elasticConfiguration.getInstallerRunCommand());
        String snapshotOrVolumeId = this.elasticImageConfiguration.getEbsSnapshotId();
        if (snapshotOrVolumeId != null) {
            metaData.put(META_AWS_EBS_SNAPSHOT_ID, snapshotOrVolumeId);
            if (ElasticImageFilesCapabilitiesHelper.supportsEbsDeviceMounting((ElasticImageConfiguration)this.elasticImageConfiguration)) {
                String imageId = this.elasticImageConfiguration.getAmiId();
                Image image = this.awsAccount.describeImage(imageId);
                Preconditions.checkState((image != null ? 1 : 0) != 0, (Object)("Unable to find image: " + imageId));
                assert (image != null);
                metaData.put(META_AWS_EBS_DEVICE, EC2Utils.getEbsDeviceName((Image)image));
            }
        }
        List startupScripts = this.elasticImageConfiguration.getStartupScripts();
        for (int i = 0; i < startupScripts.size(); ++i) {
            ElasticAgentUserDataMetadataHelper.addScript(metaData, (String)((Script)startupScripts.get(i)).getBody(), (int)i);
        }
        if (log.isDebugEnabled() && !metaData.isEmpty()) {
            log.debug((Object)"Adding meta data: ");
            for (Map.Entry entry : metaData.entrySet()) {
                log.debug((Object)((String)entry.getKey() + " : " + (String)entry.getValue()));
            }
        }
        ElasticAgentUserDataImpl agentUserData = new ElasticAgentUserDataImpl(this.baseURL.toString(), this.startupTimeoutSeconds, KeyManagerFactory.getDefaultAlgorithm(), TrustManagerFactory.getDefaultAlgorithm(), this.keyStore, metaData, SystemProperty.EC2_HTTP_TUNNEL_ENABLED.getTypedValue(), SystemProperty.EC2_JMS_TUNNEL_ENABLED.getTypedValue(), SystemProperty.EC2_IGNORE_CERT_CHECK.getValue(false), this.manager.getTunnelPort(), this.manager.getAgentSideHttpPort(), this.manager.getAgentSideJmsPort(), this.elasticImageConfiguration.getId(), this.elasticImageConfiguration.getConfigurationName());
        this.instanceLaunchConfigurationBuilder.withImageId(this.elasticImageConfiguration.getAmiId()).withInstanceTypes(this.elasticImageConfiguration.getInstanceTypes()).withAvailabilityZone((Iterable)this.elasticImageConfiguration.getAvailabilityZones()).withAvailableSubnetIds((Iterable)this.elasticImageConfiguration.getSubnetIds()).withUserData((Object)agentUserData).withStartupTimeoutSeconds(this.startupTimeoutSeconds).withIamInstanceProfile(ElasticImageConfigurationCapabilities.getIamInstanceProfile((ElasticImageConfiguration)this.elasticImageConfiguration)).withEbsOptimised(ElasticImageConfigurationCapabilities.isEbsOptimised((ElasticImageConfiguration)this.elasticImageConfiguration));
        boolean bl = useBdmForEbs = ElasticImageFilesCapabilitiesHelper.supportsBdmVolumeCreation((ElasticImageConfiguration)this.elasticImageConfiguration) && RemoteElasticInstanceEbsHelperImpl.isSnapshot(snapshotOrVolumeId);
        if (useBdmForEbs) {
            this.instanceLaunchConfigurationBuilder.withEbsSnapsthotId(snapshotOrVolumeId);
        }
        this.instanceLaunchConfigurationBuilder.withShouldAssociatePublicIp(this.elasticConfiguration.isPublicIpForVpcEnabled());
        this.instanceLaunchConfigurationBuilder.withRootFsSizeOverride(this.elasticImageConfiguration.getRootFsSizeOverride());
        if (this.spotInstanceConfig.isEnabled()) {
            double maxAccteptableSpotPrice;
            SpotPriceMatrix.Price bid = this.getMaximumAcceptableBid(this.elasticImageConfiguration);
            double d = maxAccteptableSpotPrice = bid != null ? bid.getSpotPrice() : 0.0;
            if (maxAccteptableSpotPrice > 0.0) {
                this.instanceLaunchConfigurationBuilder.withSpotRequestTimeoutSeconds(this.spotInstanceConfig.getSpotRequestTimeoutSeconds()).withSpotInstanceBid(maxAccteptableSpotPrice);
            }
        }
        boolean shouldServerPrepareVolume = !useBdmForEbs && ElasticImageFilesCapabilitiesHelper.supportsEbsDeviceMounting((ElasticImageConfiguration)this.elasticImageConfiguration);
        this.ec2Instance = this.awsAccount.newEC2Instance(this.instanceLaunchConfigurationBuilder.build(), (EC2InstanceListener)new Ec2InstanceListenerImpl(shouldServerPrepareVolume));
    }

    private void attachAccountDetails(Map<String, String> metaData) throws IOException {
        log.debug((Object)"Uploading of AWS account details is enabled");
        String accountPrivateKeyFile = this.elasticConfiguration.getAwsPrivateKeyFile();
        String accountCertFile = this.elasticConfiguration.getAwsCertFile();
        boolean accountCertFileDefined = StringUtils.isNotBlank((CharSequence)accountCertFile);
        boolean accountPrivateKeyFileDefined = StringUtils.isNotBlank((CharSequence)accountPrivateKeyFile);
        log.debug((Object)("Account certificate file defined: " + accountCertFileDefined));
        log.debug((Object)("Account private key file defined: " + accountPrivateKeyFileDefined));
        if (accountCertFileDefined && accountPrivateKeyFileDefined) {
            log.debug((Object)"Putting account cert file and private key file to metadata");
            String accountPrivateKey = FileUtils.readFileToString((File)new File(accountPrivateKeyFile), (Charset)Charset.defaultCharset());
            String accountCert = FileUtils.readFileToString((File)new File(accountCertFile), (Charset)Charset.defaultCharset());
            metaData.put(META_AWS_ACCOUNT_PRIVATE_KEY, accountPrivateKey);
            metaData.put(META_AWS_ACCOUNT_CERTIFICATE, accountCert);
        } else {
            log.debug((Object)"Not putting account cert file and private key file to metadata");
        }
        if (this.elasticConfiguration.getAwsCredentialsType() == AwsCredentialsType.ACCESS_KEY) {
            log.debug((Object)"Attaching AWS access and secret keys");
            String decryptedAwsSecretKey = this.secretEncryptionService.decrypt(this.elasticConfiguration.getAwsSecretKey());
            ElasticAgentUserDataMetadataHelper.setAwsAccessKey(metaData, (String)this.elasticConfiguration.getAwsAccessKeyId());
            ElasticAgentUserDataMetadataHelper.setAwsSecretKey(metaData, (String)decryptedAwsSecretKey);
        } else {
            log.debug((Object)"Not attaching AWS keys, since Bamboo is using IAM instance profile for AWS access");
        }
    }

    @Nullable
    private SpotPriceMatrix.Price getMaximumAcceptableBid(ElasticImageConfiguration elasticImageConfiguration) {
        Iterable instanceTypes = elasticImageConfiguration.getInstanceTypes();
        if (Iterables.size((Iterable)instanceTypes) == 1) {
            EC2InstanceType instanceType = (EC2InstanceType)Iterables.getOnlyElement((Iterable)instanceTypes);
            return this.spotInstanceConfig.getBid(elasticImageConfiguration.getProduct(), instanceType.getAwsInstanceType());
        }
        SpotPriceMatrix.Price minimumBid = null;
        for (EC2InstanceType instanceType : instanceTypes) {
            SpotPriceMatrix.Price bid = this.spotInstanceConfig.getBid(elasticImageConfiguration.getProduct(), instanceType.getAwsInstanceType());
            if (bid == null || bid.getSpotPrice() == 0.0 || minimumBid != null && !(minimumBid.getSpotPrice() > bid.getSpotPrice())) continue;
            minimumBid = bid;
        }
        return minimumBid;
    }

    private void addAssemblyLocation(Map<String, String> metaData, AwsSupportConstants.Region region) {
        String serverVersionSpecificDataKey;
        ImageData shippedElasticImageData;
        String msg = "Starting instance without agent assembly location, expect slow agent startup";
        try {
            shippedElasticImageData = ElasticConfigurationImpl.getShippedElasticImageData();
        }
        catch (IOException e) {
            log.warn((Object)"Starting instance without agent assembly location, expect slow agent startup", (Throwable)e);
            return;
        }
        String bucket = (String)ObjectUtils.firstNonNull((Object[])new String[]{SystemProperty.CUSTOM_S3_ASSEMBLY_BUCKET.getValue(), shippedElasticImageData.getAssemblyBucket(region), ""});
        if (StringUtils.isBlank((CharSequence)bucket)) {
            log.warn((Object)"Starting instance without agent assembly location, expect slow agent startup");
            return;
        }
        String bootstrapKey = shippedElasticImageData.getBootstrapKey();
        if (StringUtils.isNotBlank((CharSequence)bootstrapKey)) {
            ElasticAgentUserDataMetadataHelper.setBootstrapLocation(metaData, (String)(bucket + "/" + bootstrapKey));
        }
        if (StringUtils.isNotBlank((CharSequence)(serverVersionSpecificDataKey = shippedElasticImageData.getServerVersionSpecificDataKey()))) {
            ElasticAgentUserDataMetadataHelper.setVersionSpecificDataLocation(metaData, (String)("s3://" + bucket + "/" + serverVersionSpecificDataKey));
        }
        ElasticAgentUserDataMetadataHelper.setInstanceSpecificDataLocations(metaData, (String)SystemProperty.BAMBOO_INSTANCE_SPECIFIC_DATA_LOCATIONS.getValue(""));
    }

    private void addToMetaDataIfExists(Map<String, String> metaData, SystemProperty systemProperty) {
        if (systemProperty.exists()) {
            metaData.put(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    public RemoteElasticInstanceImpl(ElasticInstanceManager manager, ElasticAgentTunnelManager tunnelManager, ErrorHandler errorHandler, AWSAccount awsAccount, URL baseURL, int startupTimeoutSeconds, RemoteElasticInstanceListener listener, ScheduledExecutorService executor, KeyStore keyStore, ElasticConfiguration elasticConfiguration, @NotNull AgentManager agentManager, @NotNull ElasticImageConfiguration elasticImageConfiguration, @NotNull InstanceLaunchConfigurationBuilder instanceLaunchConfigurationBuilder, @NotNull SpotInstanceConfig spotInstanceConfig, @NotNull ServerFingerprint fingerprint, @NotNull EventPublisher eventPublisher, @NotNull SecretEncryptionService secretEncryptionService) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"A listener must be supplied.");
        this.elasticConfiguration = elasticConfiguration;
        this.manager = manager;
        this.tunnelManager = tunnelManager;
        this.errorHandler = errorHandler;
        this.awsAccount = awsAccount;
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        this.baseURL = baseURL;
        this.listener = listener;
        this.executor = executor;
        this.keyStore = keyStore;
        this.agentManager = agentManager;
        this.elasticImageConfiguration = elasticImageConfiguration;
        this.instanceLaunchConfigurationBuilder = instanceLaunchConfigurationBuilder;
        this.spotInstanceConfig = spotInstanceConfig;
        this.fingerprint = fingerprint;
        this.eventPublisher = eventPublisher;
        this.secretEncryptionService = secretEncryptionService;
    }

    public void start() {
        if (!this.state.compareAndSet(RemoteElasticInstanceState.INITIAL, RemoteElasticInstanceState.STARTING)) {
            throw new IllegalStateException("Already started.");
        }
        this.executor.execute(this.starter);
    }

    public void terminate() {
        if (this.ec2Instance == null) {
            throw new IllegalStateException("Not started.");
        }
        this.ec2Instance.asyncTerminate();
    }

    public RemoteElasticInstanceState getState() {
        return this.state.get();
    }

    synchronized void setState(RemoteElasticInstanceState state) {
        RemoteElasticInstanceState oldState = this.state.getAndSet(state);
        this.listener.elasticInstanceStateChanged((RemoteElasticInstance)this, oldState, state);
        if (state.isFinal() && this.tunnels != null) {
            for (Tunnel tunnel : this.tunnels) {
                tunnel.close();
            }
        }
    }

    private void stopAgents() {
        BuildAgent agent;
        if (this.getRemoteAgent() != 0L && (agent = this.agentManager.getAgent(this.getRemoteAgent())) != null) {
            this.agentManager.stopAgent(agent);
        }
    }

    @NotNull
    private String messageHelper(RemoteEC2Instance ec2Instance, @Nullable String stateMessage, @Nullable String ec2message) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("EC2 Instance");
        if (ec2Instance != null && ec2Instance.getInstanceId() != null) {
            errorMessage.append(" ").append(ec2Instance.getInstanceId());
        }
        if (stateMessage != null) {
            errorMessage.append(" ").append(stateMessage);
        }
        if (StringUtils.isNotBlank((CharSequence)ec2message)) {
            errorMessage.append(": ").append(ec2message);
        }
        return errorMessage.toString();
    }

    public RemoteEC2Instance getInstance() {
        return this.ec2Instance;
    }

    @NotNull
    public Collection<EBSVolume> getAttachedVolumes() {
        Instance instance;
        String instanceId = this.getInstance().getInstanceStatus().getInstanceId();
        ArrayList<EBSVolume> ebsVolumes = new ArrayList<EBSVolume>();
        if (instanceId == null) {
            return ebsVolumes;
        }
        try {
            instance = (Instance)Iterables.getOnlyElement((Iterable)this.awsAccount.describeInstances(new String[]{instanceId}));
        }
        catch (AmazonServiceException e) {
            log.info((Object)e.toString());
            log.debug((Object)"", (Throwable)e);
            return ebsVolumes;
        }
        for (InstanceBlockDeviceMapping blockDeviceMapping : instance.getBlockDeviceMappings()) {
            final String volumeId = blockDeviceMapping.getEbs().getVolumeId();
            ebsVolumes.add(new EBSVolume(){

                public String getID() {
                    return volumeId;
                }

                public void delete() throws AWSException {
                    RemoteElasticInstanceImpl.this.awsAccount.deleteVolume(volumeId);
                }
            });
        }
        return ebsVolumes;
    }

    @NotNull
    public ElasticImageConfiguration getConfiguration() {
        return this.elasticImageConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDelayedTermination(long delaySeconds) {
        Object object = this.scheduledTerminationLock;
        synchronized (object) {
            boolean hasScheduledTermination;
            boolean bl = hasScheduledTermination = this.scheduledTerminationFuture != null && !this.scheduledTerminationFuture.isDone();
            if (!hasScheduledTermination && this.isShutdownable() && !this.isBeingTerminated()) {
                Runnable terminator = () -> {
                    try {
                        this.terminate();
                    }
                    catch (IllegalStateException e) {
                        log.warn((Object)("Elastic instance " + this.getInstance().getInstanceId() + " has already been terminated."), (Throwable)e);
                    }
                };
                this.scheduledTerminationFuture = this.executor.schedule(terminator, delaySeconds, TimeUnit.SECONDS);
                log.info((Object)("Instance " + this.getInstance().getInstanceId() + " will be terminated in " + delaySeconds + " seconds"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptDelayedTermination() {
        Object object = this.scheduledTerminationLock;
        synchronized (object) {
            if (this.scheduledTerminationFuture != null) {
                boolean mayInterruptIfRunning = false;
                this.scheduledTerminationFuture.cancel(false);
            }
        }
    }

    public void setTunnelTimeoutMinutes(int tunnelTimeoutMinutes) {
        this.tunnelTimeoutMinutes = tunnelTimeoutMinutes;
    }

    public void restoreInstance(ElasticAgentDefinition elasticAgentDefinition, Instance instance) throws Exception {
        this.state.getAndSet(RemoteElasticInstanceState.RUNNING);
        this.agentId = elasticAgentDefinition.getId();
        try {
            this.initEc2InstanceObject();
            this.ec2Instance.reconnectToRunningInstance(instance);
            this.tunnels = this.tunnelManager.startBambooTunnels(this.ec2Instance, this.tunnelTimeoutMinutes);
        }
        catch (Exception throwable) {
            String message = "Failed to restore remote elastic instance.";
            log.error((Object)message, (Throwable)throwable);
            this.errorHandler.recordElasticError(message, null, (Throwable)throwable, this.ec2Instance != null ? this.ec2Instance.getInstanceId() : null);
            if (this.ec2Instance != null) {
                this.ec2Instance.asyncTerminate();
            }
            throw throwable;
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    private class Ec2InstanceListenerImpl
    implements EC2InstanceListener {
        private final RemoteElasticInstanceEbsHelper ebsHandler;

        private Ec2InstanceListenerImpl(boolean shouldServerPrepareVolume) {
            this.ebsHandler = shouldServerPrepareVolume ? new RemoteElasticInstanceEbsHelperImpl(RemoteElasticInstanceImpl.this.awsAccount, RemoteElasticInstanceImpl.this.elasticImageConfiguration) : RemoteElasticInstanceEbsHelper.NOOP;
        }

        public void onInstanceAddressChange(String previousAddress, String newAddress) {
            if (RemoteElasticInstanceImpl.this.tunnels == null) {
                return;
            }
            for (Tunnel tunnel : RemoteElasticInstanceImpl.this.tunnels) {
                tunnel.closeAllTunnels(previousAddress);
            }
        }

        public void ec2InstanceStateChanged(RemoteEC2Instance ec2Instance, EC2InstanceState previousState, EC2InstanceState newState, @Nullable String message, Throwable throwable) {
            switch (newState) {
                case BIDDING: {
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.BIDDING);
                    break;
                }
                case PENDING: {
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.IDENTIFIED);
                    try {
                        this.ebsHandler.createEbsVolumesIfNeeded(ec2Instance);
                    }
                    catch (Exception e) {
                        String msg = "Error during creation of EBS volumes for image configuration [" + RemoteElasticInstanceImpl.this.elasticImageConfiguration.getConfigurationName() + "]";
                        log.error((Object)(msg + " Terminating EC2 instance."), (Throwable)e);
                        RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(msg, null, (Throwable)e, ec2Instance.getInstanceId());
                        ec2Instance.asyncTerminate();
                    }
                    break;
                }
                case FAILED_TO_START: {
                    RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(RemoteElasticInstanceImpl.this.messageHelper(ec2Instance, "failed to start", message), null, throwable, ec2Instance != null ? ec2Instance.getInstanceId() : null);
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.FAILED_TO_START);
                    break;
                }
                case RUNNING: {
                    RemoteElasticInstanceImpl.this.setAgentLoading(true);
                    Object msg = "unknown error";
                    try {
                        msg = "Error during creation of EBS volumes for image configuration [" + RemoteElasticInstanceImpl.this.elasticImageConfiguration.getConfigurationName() + "]";
                        this.ebsHandler.createEbsVolumesIfNeeded(ec2Instance);
                        msg = "Error when attaching EBS volumes to instance " + ec2Instance.getInstanceId();
                        this.ebsHandler.attachEbsVolumes(ec2Instance);
                        msg = "Failed to start Bamboo tunnels. Terminating EC2 instance " + ec2Instance.getInstanceId();
                        RemoteElasticInstanceImpl.this.tunnels = RemoteElasticInstanceImpl.this.tunnelManager.startBambooTunnels(ec2Instance, RemoteElasticInstanceImpl.this.tunnelTimeoutMinutes);
                        RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.RUNNING);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error during elastic instance setup. Terminating EC2 instance.", (Throwable)e);
                        RemoteElasticInstanceImpl.this.errorHandler.recordElasticError((String)msg, null, (Throwable)e, ec2Instance.getInstanceId());
                        ec2Instance.asyncTerminate();
                    }
                    break;
                }
                case STOPPING: {
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.STOPPING);
                    break;
                }
                case STOPPED: {
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.STOPPED);
                    break;
                }
                case SHUTTING_DOWN: {
                    if (throwable != null) {
                        RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(RemoteElasticInstanceImpl.this.messageHelper(ec2Instance, "is shutting down", message), null, throwable, ec2Instance != null ? ec2Instance.getInstanceId() : null);
                    }
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.SHUTTING_DOWN);
                    break;
                }
                case TERMINATED: {
                    if (throwable != null) {
                        RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(RemoteElasticInstanceImpl.this.messageHelper(ec2Instance, "has terminated", message), null, throwable, ec2Instance != null ? ec2Instance.getInstanceId() : null);
                    }
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.TERMINATED);
                    RemoteElasticInstanceImpl.this.stopAgents();
                    this.ebsHandler.tearDownVolumes();
                    break;
                }
                default: {
                    String unknownStateMessage = RemoteElasticInstanceImpl.this.messageHelper(ec2Instance, "is in an unrecognised state: " + newState, message);
                    RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(unknownStateMessage, null, throwable, ec2Instance != null ? ec2Instance.getInstanceId() : null);
                    log.error((Object)unknownStateMessage);
                    RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.UNKNOWN);
                    RemoteElasticInstanceImpl.this.stopAgents();
                }
            }
        }
    }

    private class Starter
    implements Runnable {
        private Starter() {
        }

        @Override
        public void run() {
            try {
                RemoteElasticInstanceImpl.this.initEc2InstanceObject();
                RemoteElasticInstanceImpl.this.ec2Instance.start();
            }
            catch (Throwable throwable) {
                String message = "Failed to start remote elastic instance.";
                log.error((Object)message, throwable);
                RemoteElasticInstanceImpl.this.errorHandler.recordElasticError(message, null, throwable, RemoteElasticInstanceImpl.this.ec2Instance != null ? RemoteElasticInstanceImpl.this.ec2Instance.getInstanceId() : null);
                RemoteElasticInstanceImpl.this.setState(RemoteElasticInstanceState.FAILED_TO_START);
                RemoteElasticInstanceImpl.this.eventPublisher.publish((Object)new ElasticImageFailedToStartEvent(RemoteElasticInstanceImpl.this.elasticImageConfiguration.getId()));
            }
        }
    }
}

