/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;

public class ShutdownOrderComparator
implements Comparator<RemoteElasticInstance> {
    private final AgentManager agentManager;

    public ShutdownOrderComparator(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    @Override
    public int compare(@NotNull RemoteElasticInstance o1, @NotNull RemoteElasticInstance o2) {
        Preconditions.checkArgument((o1 != null ? 1 : 0) != 0);
        Preconditions.checkArgument((o2 != null ? 1 : 0) != 0);
        BuildAgent buildAgent1 = this.agentManager.getAgent(o1.getRemoteAgent());
        BuildAgent buildAgent2 = this.agentManager.getAgent(o2.getRemoteAgent());
        if (buildAgent1 == buildAgent2) {
            return 0;
        }
        if (buildAgent1 == null) {
            return -1;
        }
        if (buildAgent2 == null) {
            return 1;
        }
        AgentStatus agentStatus1 = buildAgent1.getAgentStatus();
        AgentStatus agentStatus2 = buildAgent2.getAgentStatus();
        CompareToBuilder compareToBuilder = new CompareToBuilder().append(!buildAgent1.isRequestedToBeStopped(), !buildAgent2.isRequestedToBeStopped()).append(buildAgent1.isEnabled(), buildAgent2.isEnabled()).append(agentStatus1.getOrderIndex(), agentStatus2.getOrderIndex());
        return compareToBuilder.toComparison();
    }
}

