/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.tunnel;

import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelManager;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelManagerImpl;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelPorts;
import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.tunnel.utils.http.proxy.HttpTunnelSocketFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public enum DefaultElasticAgentTunnelManagerFactory {
    INSTANCE;

    private static final String KEY_PROXY_TUNNEL_SOCKET_FACTORY = "com.atlassian.bamboo.agent.elastic.tunnel.http.proxyTunnelSocketFactory";
    private static final String KEY_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String KEY_HTTP_PROXY_PORT = "http.proxyPort";
    private final InetSocketAddress httpProxyAddress;
    private static final int DEFAULT_HTTP_PROXY_PORT = 3128;

    private DefaultElasticAgentTunnelManagerFactory() {
        boolean useProxyForTunnel = new SystemProperty.BooleanSystemProperty(false, false, new String[]{KEY_PROXY_TUNNEL_SOCKET_FACTORY}).getTypedValue();
        if (useProxyForTunnel) {
            String httpProxyHost = new SystemProperty(false, new String[]{KEY_HTTP_PROXY_HOST}).getValue();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)httpProxyHost), (String)"Bamboo is configured to use an HTTP proxy for tunneling, but %s system property is blank.", (Object)KEY_HTTP_PROXY_HOST);
            int httpProxyPort = (int)new SystemProperty.IntegerSystemProperty(false, 3128L, new String[]{KEY_HTTP_PROXY_PORT}).getTypedValue();
            this.httpProxyAddress = new InetSocketAddress(httpProxyHost, httpProxyPort);
        } else {
            this.httpProxyAddress = null;
        }
    }

    @Nullable
    @VisibleForTesting
    InetSocketAddress getHttpProxyAddress() {
        return this.httpProxyAddress;
    }

    public ElasticAgentTunnelManager create(URL baseURL, SSLContext sslContext, BambooBrokerService brokerService, ElasticAgentTunnelPorts ports) {
        String httpUserAgent = "Atlassian Bamboo " + BuildUtils.getVersionAndBuild();
        Supplier<SocketFactory> tunnelSocketFactory = this.httpProxyAddress != null ? () -> new HttpTunnelSocketFactory(this.httpProxyAddress, sslContext, httpUserAgent) : sslContext::getSocketFactory;
        return new ElasticAgentTunnelManagerImpl(baseURL, tunnelSocketFactory, brokerService, ports);
    }
}

