/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.tunnel;

import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelManager;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelPorts;
import com.atlassian.bamboo.agent.elastic.tunnel.TerminateOnTimeoutTunnelStatusTracker;
import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.utils.BambooNetworkUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.tunnel.tunnel.client.Tunnel;
import com.atlassian.tunnel.tunnel.client.TunnelServerAddressProvider;
import com.atlassian.tunnel.tunnel.client.TunnelStatusTracker;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ElasticAgentTunnelManagerImpl
implements ElasticAgentTunnelManager {
    private static final Logger log = Logger.getLogger(ElasticAgentTunnelManagerImpl.class);
    private static final boolean IS_HTTP_TUNNEL_ENABLED = SystemProperty.EC2_HTTP_TUNNEL_ENABLED.getValue(true);
    private static final boolean IS_JMS_TUNNEL_ENABLED = SystemProperty.EC2_JMS_TUNNEL_ENABLED.getTypedValue();
    private final URL baseURL;
    private final Supplier<SocketFactory> socketFactory;
    private final ElasticAgentTunnelPorts ports;
    private final BambooBrokerService brokerService;

    public ElasticAgentTunnelManagerImpl(URL baseURL, Supplier<SocketFactory> socketFactory, BambooBrokerService brokerService, ElasticAgentTunnelPorts ports) {
        this.baseURL = baseURL;
        this.socketFactory = socketFactory;
        this.brokerService = brokerService;
        this.ports = ports;
    }

    @Override
    @NotNull
    public Collection<Tunnel> startBambooTunnels(@NotNull RemoteEC2Instance ec2Instance, int tunnelTimeoutMinutes) {
        ArrayList<Tunnel> tunnels = new ArrayList<Tunnel>();
        ArrayList<String> disabledTunnels = new ArrayList<String>();
        if (IS_HTTP_TUNNEL_ENABLED) {
            tunnels.add(this.startTunnel(ec2Instance, this.ports.getAgentSideHttpPort(), this.baseURL.getHost(), this.getHTTPPort(), tunnelTimeoutMinutes));
        } else {
            disabledTunnels.add("HTTP");
        }
        if (IS_JMS_TUNNEL_ENABLED) {
            URI brokerURI = this.brokerService.getEndpointForJmsTunnel();
            String jmsHost = brokerURI.getHost();
            int jmsPort = brokerURI.getPort();
            tunnels.add(this.startTunnel(ec2Instance, this.ports.getAgentSideJmsPort(), jmsHost, jmsPort, tunnelTimeoutMinutes));
        } else {
            disabledTunnels.add("JMS");
        }
        if (!disabledTunnels.isEmpty()) {
            log.info((Object)("Tunnelling will not be used for " + ec2Instance.getInstanceId() + " over " + disabledTunnels));
        }
        return tunnels;
    }

    private Tunnel startTunnel(final @NotNull RemoteEC2Instance ec2Instance, int remoteProxyPort, String destinationHost, int destinationPort, int tunnelTimeoutMinutes) {
        TunnelServerAddressProvider tunnelAddressProvider = new TunnelServerAddressProvider(){

            @NotNull
            public InetAddress getTunnelAddress() {
                String address = ec2Instance.getInstanceStatus().getAddress();
                InetAddress reachableAddress = BambooNetworkUtils.getReachableAddress((String)address, (int)ElasticAgentTunnelManagerImpl.this.ports.getTunnelPort());
                if (reachableAddress == null) {
                    return BambooNetworkUtils.getInetAddressByName((String)address);
                }
                return reachableAddress;
            }

            public int getTunnelPort() {
                return ElasticAgentTunnelManagerImpl.this.ports.getTunnelPort();
            }
        };
        InetAddress destinationHostAddress = BambooNetworkUtils.getInetAddressByName((String)destinationHost);
        Tunnel tunnel = new Tunnel(remoteProxyPort, tunnelAddressProvider, destinationHostAddress, destinationPort, (TunnelStatusTracker)new TerminateOnTimeoutTunnelStatusTracker(ec2Instance, tunnelTimeoutMinutes, TimeUnit.MINUTES), this.getTunnelSocketFactory(), this.getForwardingSocketFactory());
        tunnel.open();
        return tunnel;
    }

    private SocketFactory getForwardingSocketFactory() {
        return SocketFactory.getDefault();
    }

    private SocketFactory getTunnelSocketFactory() {
        return this.socketFactory.get();
    }

    private int getHTTPPort() {
        int specifiedPort = this.baseURL.getPort();
        return specifiedPort == -1 ? this.baseURL.getDefaultPort() : specifiedPort;
    }
}

