/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.tunnel;

import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.tunnel.tunnel.client.DefaultTunnelStatusTracker;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TerminateOnTimeoutTunnelStatusTracker
extends DefaultTunnelStatusTracker {
    private static final Logger log = Logger.getLogger(TerminateOnTimeoutTunnelStatusTracker.class);
    private final RemoteEC2Instance ec2Instance;
    private final long timeoutMillis;
    private long timeoutExpiration;

    public TerminateOnTimeoutTunnelStatusTracker(RemoteEC2Instance ec2Instance, int timeout, TimeUnit timeUnit) {
        this.ec2Instance = ec2Instance;
        this.timeoutMillis = timeUnit.toMillis(timeout);
    }

    public void onAttempt() {
        if (this.consecutiveFailures == 0) {
            this.resetTimeout();
        }
        super.onAttempt();
    }

    public void onFailure(@Nullable Throwable throwable) throws InterruptedException {
        if (!this.atLeastOneConnectionWasSuccessful && System.currentTimeMillis() > this.timeoutExpiration) {
            log.error((Object)("Timeout has expired for waiting for tunnel to instance [" + this.ec2Instance.getInstanceId() + "], terminating [" + this.tunnelName + "] Error: " + (throwable != null ? throwable.getMessage() : null)), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception for tunnel expiry", throwable);
            }
            this.ec2Instance.asyncTerminate();
            Thread.currentThread().interrupt();
        }
        super.onFailure(throwable);
    }

    public void onSuccess() {
        super.onSuccess();
    }

    private void resetTimeout() {
        this.timeoutExpiration = System.currentTimeMillis() + this.timeoutMillis;
    }
}

