/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic;

public class ScriptInterpreterUtils {
    private static final String[] DEFAULT_UNIX_INTERPRETER = new String[]{"/bin/sh"};
    private static final String[] DEFAULT_SYSTEM_INTERPRETER = new String[0];

    public static String getFirstLine(String scriptBody) {
        String firstLine = scriptBody;
        int i = scriptBody.indexOf(10);
        if (i != -1) {
            firstLine = scriptBody.substring(0, i);
        }
        if ((i = scriptBody.indexOf(13)) != -1) {
            firstLine = scriptBody.substring(0, i);
        }
        return firstLine;
    }

    public static String[] getInterpreter(String scriptBody, boolean isOsWindows) {
        boolean hasShebang = scriptBody.startsWith("#!");
        if (hasShebang && !isOsWindows) {
            return DEFAULT_SYSTEM_INTERPRETER;
        }
        return hasShebang ? ScriptInterpreterUtils.getCommandInterpreterFromShebang(scriptBody) : ScriptInterpreterUtils.getDefaultCommandInterpreter(isOsWindows);
    }

    static String[] getCommandInterpreterFromShebang(String scriptBody) {
        String firstLine = ScriptInterpreterUtils.getFirstLine(scriptBody);
        String lineAfterMagic = firstLine.substring(2);
        String[] interpreterAndArg = lineAfterMagic.trim().split("\\s+", 2);
        return interpreterAndArg.length == 0 ? DEFAULT_SYSTEM_INTERPRETER : interpreterAndArg;
    }

    private static String[] getDefaultCommandInterpreter(boolean isOsWindows) {
        return isOsWindows ? DEFAULT_SYSTEM_INTERPRETER : DEFAULT_UNIX_INTERPRETER;
    }
}

