/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.bootstrap.http;

import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentHttpClientFactory;
import com.atlassian.bamboo.agent.bootstrap.http.SchemeRegistryFactory;
import com.atlassian.bamboo.agent.elastic.tunnel.DoubleSSLSocketFactory;
import com.atlassian.bamboo.agent.elastic.tunnel.HandlerRegistry;
import com.atlassian.bamboo.agent.elastic.tunnel.HandlerUtils;
import java.util.Map;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElasticAgentSchemeRegistryFactory
implements SchemeRegistryFactory {
    private static final Logger log = LogManager.getLogger(ElasticAgentSchemeRegistryFactory.class);
    private final SchemeRegistryFactory remoteAgentSchemeRegistryFactory;
    private final boolean shouldStartHttpTunnel;
    private final boolean isHttpsBaseURL;
    private final boolean ignoreCertificateChecks;
    private final String virtualHost;

    public ElasticAgentSchemeRegistryFactory(SchemeRegistryFactory remoteAgentSchemeRegistryFactory, boolean shouldStartHttpTunnel, boolean isHttpsBaseURL, boolean ignoreCertificateChecks, String virtualHost) {
        this.remoteAgentSchemeRegistryFactory = remoteAgentSchemeRegistryFactory;
        this.shouldStartHttpTunnel = shouldStartHttpTunnel;
        this.isHttpsBaseURL = isHttpsBaseURL;
        this.ignoreCertificateChecks = ignoreCertificateChecks;
        this.virtualHost = virtualHost;
    }

    public Map<String, ConnectionSocketFactory> newSchemeRegistry(RemoteAgentHttpClientFactory httpClientFactory) {
        Map schemeRegistry = this.remoteAgentSchemeRegistryFactory.newSchemeRegistry(httpClientFactory);
        if (this.shouldStartHttpTunnel) {
            log.info("Using tunnelling for HTTP(S). Registering '" + HandlerRegistry.HTTPT_SCHEME + "' and '" + HandlerRegistry.HTTPST_SCHEME + "' protocols.");
            try {
                schemeRegistry.put(HandlerRegistry.HTTPT_SCHEME, (ConnectionSocketFactory)schemeRegistry.get("http"));
                schemeRegistry.put(HandlerRegistry.HTTPST_SCHEME, new DoubleSSLSocketFactory());
                HandlerUtils.setHostName(this.virtualHost);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (this.ignoreCertificateChecks && this.isHttpsBaseURL) {
            log.info("Ignoring certificate checks for Bamboo HTTPS. Registering '" + HandlerRegistry.HTTPST_SCHEME + "' protocol.");
            try {
                schemeRegistry.put(HandlerRegistry.HTTPST_SCHEME, new DoubleSSLSocketFactory());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            log.info("Using standard protocol handlers for HTTP(S).");
        }
        return schemeRegistry;
    }
}

