/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.client;

import com.atlassian.aws.ec2.Ec2UtilsThin;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentBootstrap;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentHttpClientFactory;
import com.atlassian.bamboo.agent.bootstrap.http.SchemeRegistryFactory;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserData;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataImpl;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataMetadataHelper;
import com.atlassian.bamboo.agent.elastic.bootstrap.http.ElasticAgentSchemeRegistryFactory;
import com.atlassian.bamboo.agent.elastic.client.BooleanUtils;
import com.atlassian.bamboo.agent.elastic.client.ElasticAgentSynchroniser;
import com.atlassian.bamboo.agent.elastic.tunnel.HandlerRegistry;
import com.atlassian.bamboo.agent.elastic.tunnel.SSLContextFactoryImpl;
import com.atlassian.tunnel.tunnel.server.TunnelListener;
import com.atlassian.tunnel.tunnel.server.TunnelServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElasticAgentBootstrap
extends RemoteAgentBootstrap {
    private static final Logger log = LogManager.getLogger(ElasticAgentBootstrap.class);
    private static final int TUNNEL_TIMEOUT_MINUTES = 30;
    private final ElasticAgentUserData userData;
    private final SSLContext sslContext;

    public static void main(String[] arguments) throws Exception {
        AgentTypeHolder.set((AgentType)AgentType.ELASTIC);
        ElasticAgentBootstrap.configureLogging();
        log.info("Starting Agent Bootstrap using Java " + System.getProperty("java.version") + " from " + System.getProperty("java.vm.vendor"));
        ElasticAgentUserData userData = (ElasticAgentUserData)Ec2UtilsThin.getUserData(ElasticAgentUserDataImpl.class);
        ElasticAgentSynchroniser elasticAgentSynchroniser = new ElasticAgentSynchroniser();
        elasticAgentSynchroniser.sync();
        ElasticAgentBootstrap elasticAgentBootstrap = new ElasticAgentBootstrap(userData);
        elasticAgentBootstrap.run(AgentType.ELASTIC);
    }

    ElasticAgentBootstrap(ElasticAgentUserData userData) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(new URL(userData.getBaseURL()), null, AgentType.ELASTIC);
        this.userData = userData;
        this.sslContext = new SSLContextFactoryImpl(userData.getKeyManagerAlgorithmName(), userData.getTrustManagerAlgorithmName()).newSSLContext(userData.getKeyStore());
    }

    protected void run(AgentType type) {
        try {
            this.startTunnelServer();
            super.run(type);
        }
        catch (Exception exception) {
            log.error("Fatal exception.", (Throwable)exception);
        }
    }

    private void startTunnelServer() throws TimeoutException {
        log.info("HTTP(S) tunnel: " + BooleanUtils.toString(this.userData.isUseTunnelForHttp(), "enabled", "disabled"));
        log.info("JMS tunnel: " + BooleanUtils.toString(this.userData.shouldUseTunnelForJms(), "enabled", "disabled"));
        int expectedTunnelCount = BooleanUtils.toInteger(this.userData.isUseTunnelForHttp()) + BooleanUtils.toInteger(this.userData.shouldUseTunnelForJms());
        if (expectedTunnelCount == 0) {
            return;
        }
        final CountDownLatch allTunnelsStarted = new CountDownLatch(expectedTunnelCount);
        Thread tunnelServerThread = new Thread((Runnable)new TunnelServer(this.getTunnelPort(), (ServerSocketFactory)this.sslContext.getServerSocketFactory(), new TunnelListener(){

            public void tunnelAccepted(int port) {
                if (port == ElasticAgentBootstrap.this.getJMSProxyPort() || port == ElasticAgentBootstrap.this.getHTTPProxyPort() && ElasticAgentBootstrap.this.userData.isUseTunnelForHttp()) {
                    allTunnelsStarted.countDown();
                }
            }
        }), TunnelServer.class.getName());
        tunnelServerThread.setDaemon(true);
        tunnelServerThread.start();
        log.info("Starting tunnel server, waiting for " + expectedTunnelCount + " connections. ");
        boolean interrupted = false;
        boolean countDownSuccessful = false;
        do {
            try {
                countDownSuccessful = allTunnelsStarted.await(30L, TimeUnit.MINUTES);
            }
            catch (InterruptedException exception) {
                interrupted = true;
            }
        } while (interrupted);
        if (!countDownSuccessful) {
            throw new TimeoutException("The server has failed to contact the agent within 30 minutes. Assuming that the server is unreachable and terminating the agent.");
        }
    }

    protected SchemeRegistryFactory getSchemeRegistryDataFactory(SchemeRegistryFactory remoteAgentSchemeRegistryFactory) {
        boolean shouldStartHttpTunnel = this.userData.isUseTunnelForHttp();
        boolean isHttpsBaseURL = this.isHttpsBaseURL();
        boolean ignoreCertificateChecks = this.userData.isIgnoreCertificateChecks();
        return new ElasticAgentSchemeRegistryFactory(remoteAgentSchemeRegistryFactory, shouldStartHttpTunnel, isHttpsBaseURL, ignoreCertificateChecks, this.getVirtualHost());
    }

    protected String getFingerprintRequestSuffix() {
        StringBuilder suffix = new StringBuilder("&agentType=elastic");
        suffix.append("&fingerprint=").append(ElasticAgentUserDataMetadataHelper.getFingerprint((Map)this.userData.getMetaData()));
        try {
            if (Ec2UtilsThin.getLocalEC2Instance().getInstanceId() != null) {
                suffix.append("&instanceId=").append(Ec2UtilsThin.getLocalEC2Instance().getInstanceId());
            }
        }
        catch (IOException e) {
            log.error("Could not retrieve ec2 instance id for fingerprint.", (Throwable)e);
        }
        return suffix.toString();
    }

    protected void setHttpClientFactoryParamaters(RemoteAgentHttpClientFactory remoteAgentHttpClientFactory) {
        super.setHttpClientFactoryParamaters(remoteAgentHttpClientFactory);
        if (!this.userData.isUseTunnelForHttp()) {
            return;
        }
        String virtualHost = this.getVirtualHost();
        log.info("Using tunnelling. Setting virtual host name to " + virtualHost);
        remoteAgentHttpClientFactory.setFixedVirtualHost(virtualHost);
    }

    private String getVirtualHost() {
        URL endpoint = this.getDeclaredEndpointForAgents();
        int port = endpoint.getPort();
        return endpoint.getHost() + (String)(port == -1 ? "" : ":" + port);
    }

    protected URL getReachableEndpointForAgents() {
        URL declaredEndpointForAgents = this.getDeclaredEndpointForAgents();
        String protocol = declaredEndpointForAgents.getProtocol();
        try {
            if (this.userData.isUseTunnelForHttp()) {
                String loopbackIp = InetAddress.getLoopbackAddress().getHostAddress();
                return new URL(HandlerRegistry.getTunnelledProtocol(protocol) + "://" + loopbackIp + ":" + this.getHTTPProxyPort() + declaredEndpointForAgents.getFile());
            }
            if (this.userData.isIgnoreCertificateChecks() && this.isHttpsBaseURL()) {
                int port = declaredEndpointForAgents.getPort();
                return new URL(HandlerRegistry.getTunnelledProtocol(protocol) + "://" + declaredEndpointForAgents.getHost() + (String)(port > 0 ? ":" + port : "") + declaredEndpointForAgents.getFile());
            }
            return declaredEndpointForAgents;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("", e);
        }
    }

    public int getTunnelPort() {
        return this.userData.getTunnelPort();
    }

    public int getHTTPProxyPort() {
        return this.userData.getHTTPProxyPort();
    }

    public int getJMSProxyPort() {
        return this.userData.getJMSProxyPort();
    }
}

