/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.client;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.atlassian.aws.AmazonClients;
import com.atlassian.aws.ec2.Ec2UtilsThin;
import com.atlassian.aws.s3.EtagCalculator;
import com.atlassian.aws.s3.S3Path;
import com.atlassian.bamboo.agent.bootstrap.AgentFileManifestDao;
import com.atlassian.bamboo.agent.bootstrap.BootstrapStringUtils;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserData;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataImpl;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataMetadataHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ElasticAgentSynchroniser {
    private static final Logger log = LogManager.getLogger(ElasticAgentSynchroniser.class);
    private final TransferManager transferManager;
    private final S3Path versionSpecificDataLocation;
    private final EtagCalculator etagCalculator;
    private final List<S3Path> instanceSpecificDataLocations;
    private final File bambooHomeDir;
    private final File frameworkBundlesDir;
    private final File cachedJarsDirectory;

    public ElasticAgentSynchroniser() throws IOException {
        ElasticAgentUserData userData = ElasticAgentSynchroniser.getUserData();
        this.versionSpecificDataLocation = new S3Path(ElasticAgentUserDataMetadataHelper.getVersionSpecificDataLocation((ElasticAgentUserData)userData) + "/assembly.list");
        String instanceSpecificDataLocationsStr = ElasticAgentUserDataMetadataHelper.getInstanceSpecificDataLocations((ElasticAgentUserData)userData);
        this.instanceSpecificDataLocations = instanceSpecificDataLocationsStr == null ? Collections.emptyList() : Arrays.stream(instanceSpecificDataLocationsStr.split(",")).filter(s -> !s.isEmpty()).map(S3Path::new).collect(Collectors.toList());
        AmazonS3 s3Client = (AmazonS3)AmazonClients.setBestEndpointForBucket((AmazonS3ClientBuilder)AmazonClients.newS3Client((AWSCredentials)new AnonymousAWSCredentials()), (String)this.versionSpecificDataLocation.getBucket()).build();
        this.transferManager = TransferManagerBuilder.standard().withS3Client(s3Client).build();
        this.etagCalculator = EtagCalculator.forTransferManager((TransferManager)this.transferManager);
        this.bambooHomeDir = RemoteAgentHomeLocatorForBootstrap.getHome();
        log.info("bambooHomeDir: " + this.bambooHomeDir);
        this.frameworkBundlesDir = RemoteAgentHomeLocatorForBootstrap.getPluginFrameworkBundlesDirectory();
        this.cachedJarsDirectory = this.getCacheDirectory();
    }

    @Nullable
    private File getCacheDirectory() {
        File agentInstallationDirectory = RemoteAgentHomeLocatorForBootstrap.getInstallationDirectory();
        File cachedDirectory = new File(agentInstallationDirectory, "lib");
        return cachedDirectory.isDirectory() ? cachedDirectory : null;
    }

    public static ElasticAgentUserData getUserData() throws IOException {
        return (ElasticAgentUserData)Ec2UtilsThin.getUserData(ElasticAgentUserDataImpl.class);
    }

    public void sync() {
        HashSet<File> requiredFiles = new HashSet<File>();
        HashSet<File> syncedDirectories = new HashSet<File>();
        Path bambooHomeDirPath = Paths.get(this.bambooHomeDir.getPath(), new String[0]);
        log.info("Files in bamboo-agent-home");
        try (Stream<Path> files = Files.walk(bambooHomeDirPath, new FileVisitOption[0]);){
            files.forEach(f -> log.info((Object)f.getFileName()));
        }
        catch (IOException e) {
            log.warn("Unable to list files in " + bambooHomeDirPath);
            e.printStackTrace();
        }
        this.downloadRequiredFiles(requiredFiles, syncedDirectories);
        boolean enabledS3SynchroRemoving = Boolean.parseBoolean(System.getenv("BAMBOO_ELASTIC_S3_SYNC_REMOVING_ENABLED"));
        if (enabledS3SynchroRemoving) {
            this.removeUnnecessaryFiles(requiredFiles, syncedDirectories);
        }
        log.info("Agent jar sync finished.");
    }

    private void downloadRequiredFiles(Set<File> requiredFiles, Set<File> syncedDirectories) {
        Collection<AgentFileManifestDao.AgentFileManifestEntry> entries = this.getAgentFileManifestEntries();
        ArrayList<Download> transfers = new ArrayList<Download>();
        String bucket = this.versionSpecificDataLocation.getBucket();
        for (AgentFileManifestDao.AgentFileManifestEntry entry : entries) {
            log.info(entry.toString());
            File finalJarLocation = this.getDestination(entry);
            log.info("Final destination: " + finalJarLocation);
            if (finalJarLocation == null) {
                log.info("finalJarLocation");
                continue;
            }
            log.info("Adding to required files: " + finalJarLocation);
            requiredFiles.add(finalJarLocation);
            syncedDirectories.add(finalJarLocation.getParentFile());
            File localFile = this.findLocalFile(entry, finalJarLocation);
            if (localFile == null) {
                log.info("Downloading (missing)       : " + finalJarLocation);
                transfers.add(this.download(bucket, entry, finalJarLocation));
                continue;
            }
            if (localFile.equals(finalJarLocation)) continue;
            try {
                log.info("Copying local file          : " + finalJarLocation);
                Files.copy(localFile.toPath(), finalJarLocation.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to copy local file from " + localFile + " to " + finalJarLocation, e);
            }
        }
        log.info("Waiting for all transfers to complete...");
        transfers.forEach(ElasticAgentSynchroniser::waitForCompletion);
        this.transferManager.shutdownNow();
        log.info("Agent files downloaded successfully.");
    }

    private void removeUnnecessaryFiles(Set<File> requiredFiles, Set<File> syncedDirectories) {
        log.info("Removing spurious files...");
        for (File syncedDirectory : syncedDirectories) {
            File[] files = syncedDirectory.listFiles();
            if (files == null) {
                throw new IllegalStateException("Cannot list files in " + syncedDirectory);
            }
            for (File file : files) {
                if (requiredFiles.contains(file)) continue;
                log.info("Removing: " + file);
                file.delete();
            }
        }
    }

    private File findLocalFile(AgentFileManifestDao.AgentFileManifestEntry entry, File file) {
        if (this.isCorrectFile(entry, file)) {
            return file;
        }
        File cachedFile = new File(this.cachedJarsDirectory, file.getName());
        if (this.isCorrectFile(entry, cachedFile)) {
            return cachedFile;
        }
        return null;
    }

    private boolean isCorrectFile(AgentFileManifestDao.AgentFileManifestEntry entry, File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.length() != entry.getFileLength()) {
            log.info("Cannot use (size mismatch)  : " + file);
            return false;
        }
        if (!this.calculateEtag(file).equals(entry.getFileEtag())) {
            log.info("Cannot use (ETag mismatch)  : " + file);
            return false;
        }
        return true;
    }

    @Nullable
    private Download download(String agentDataBucket, AgentFileManifestDao.AgentFileManifestEntry entry, File file) {
        if (!entry.getRawFileLocation().startsWith("s3://")) {
            return null;
        }
        S3Path s3Path = new S3Path(entry.getFileLocation(agentDataBucket));
        String bucket = s3Path.getBucket();
        try {
            return this.transferManager.download(bucket, s3Path.getKey(), file);
        }
        catch (AmazonS3Exception e) {
            log.warn("Unable to download file: " + s3Path, (Throwable)e);
            return null;
        }
    }

    private Collection<AgentFileManifestDao.AgentFileManifestEntry> getAgentFileManifestEntries() {
        log.info("Downloading agent file lists...");
        LinkedHashSet<AgentFileManifestDao.AgentFileManifestEntry> filesToDownload = new LinkedHashSet<AgentFileManifestDao.AgentFileManifestEntry>();
        ArrayList<S3Path> listLocations = new ArrayList<S3Path>(Collections.singleton(this.versionSpecificDataLocation));
        listLocations.addAll(this.instanceSpecificDataLocations);
        int i = 0;
        for (S3Path listLocation : listLocations) {
            File manifestFile;
            try {
                manifestFile = File.createTempFile("assembly-" + i++ + "-", ".list");
                manifestFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            log.info("Downloading agent file list from " + listLocation);
            try {
                Download download = this.transferManager.download(listLocation.getBucket(), listLocation.getKey(), manifestFile);
                ElasticAgentSynchroniser.waitForCompletion((Transfer)download);
            }
            catch (AmazonS3Exception e) {
                log.warn("Unable to download assembly.list from " + listLocation, (Throwable)e);
            }
            List entries = AgentFileManifestDao.parse((File)manifestFile);
            filesToDownload.removeAll(entries);
            filesToDownload.addAll(entries);
        }
        return filesToDownload;
    }

    private String calculateEtag(File file) {
        try {
            return this.etagCalculator.calculateEtag(file);
        }
        catch (IOException e) {
            log.warn("Unable to calculate ETag for " + file, (Throwable)e);
            return "ERROR";
        }
    }

    @Nullable
    private File getDestination(AgentFileManifestDao.AgentFileManifestEntry entry) {
        Object outputDirName = entry.getCollectionId();
        switch (outputDirName) {
            case "boot": {
                return null;
            }
            case "lib": 
            case "user-plugins1": {
                outputDirName = "classpath";
                break;
            }
            case "bundled-plugins": {
                outputDirName = "plugins" + File.separatorChar + "system-provided";
                break;
            }
            case "user-plugins2": {
                outputDirName = "plugins" + File.separatorChar + "user-installed";
            }
        }
        File outputDir = ((String)outputDirName).equals("framework-bundles") ? this.frameworkBundlesDir : new File(this.bambooHomeDir, (String)outputDirName);
        try {
            Files.createDirectories(outputDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create output directory for " + entry, e);
        }
        return new File(outputDir, BootstrapStringUtils.substringAfterLast((String)entry.getRawFileLocation(), (String)"/"));
    }

    private static void waitForCompletion(@Nullable Transfer download) {
        if (download == null) {
            return;
        }
        try {
            download.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

