/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.tunnel;

import com.atlassian.bamboo.agent.elastic.tunnel.SSLContextFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactoryImpl
implements SSLContextFactory {
    private final String keyManagerAlgorithmName;
    private final String trustManagerAlgorithmName;

    public SSLContextFactoryImpl(String keyManagerAlgorithmName, String trustManagerAlgorithmName) {
        this.keyManagerAlgorithmName = keyManagerAlgorithmName;
        this.trustManagerAlgorithmName = trustManagerAlgorithmName;
    }

    @Override
    public SSLContext newSSLContext(KeyStore keyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerAlgorithmName);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        keyManagerFactory.init(keyStore, "bamboo".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerAlgorithmName);
        trustManagerFactory.init(keyStore);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }
}

