/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.ChartBuilder;
import com.atlassian.bamboo.charts.utils.DurationFormat;
import com.atlassian.core.util.RandomGenerator;
import java.io.IOException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.servlet.ServletUtilities;

public abstract class AbstractBambooChart
implements ChartBuilder {
    private static final Logger log = Logger.getLogger(AbstractBambooChart.class);
    protected int height;
    protected int width;
    protected String chartTitle;
    protected String xAxisLabel;
    protected String yAxisLabel;
    protected String contextPath;
    protected boolean shortUrlUsed;

    protected AbstractBambooChart() {
    }

    protected AbstractBambooChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel) {
        this.height = height;
        this.width = width;
        this.chartTitle = chartTitle;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
    }

    @NotNull
    protected Map<String, Object> generateChartImage(@NotNull JFreeChart chart, @NotNull Map<String, Object> params) {
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        try {
            String location = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)this.width, (int)this.height, (ChartRenderingInfo)chartRenderingInfo, null);
            log.debug((Object)("Saving chart as png, location: " + location));
            params.put("location", location);
            params.put("width", this.width);
            params.put("height", this.height);
            String mapName = this.generateRandomMapName();
            params.put("imageMap", ChartUtilities.getImageMap((String)mapName, (ChartRenderingInfo)chartRenderingInfo));
            params.put("imageMapName", mapName);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return params;
    }

    protected String generateRandomMapName() {
        return RandomGenerator.randomString((int)5) + "_map";
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public String getxAxisLabel() {
        return this.xAxisLabel;
    }

    public void setxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public String getyAxisLabel() {
        return this.yAxisLabel;
    }

    public void setyAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isShortUrlUsed() {
        return this.shortUrlUsed;
    }

    public void setShortUrlUsed(boolean shortUrlUsed) {
        this.shortUrlUsed = shortUrlUsed;
    }

    @NotNull
    protected Map<String, Object> generateChartImage(@NotNull JFreeChart chart) {
        return this.generateChartImage(chart, new HashMap<String, Object>());
    }

    protected void configureDurationRangeAxis(@NotNull JFreeChart chart, @NotNull AutoRange autoRange) {
        boolean notifyListeners = false;
        XYPlot xyPlot = chart.getXYPlot();
        DateAxis rangeAxis = new DateAxis();
        DurationFormat durationFormat = new DurationFormat();
        rangeAxis.setDateFormatOverride((DateFormat)durationFormat);
        rangeAxis.setLabel("Duration");
        rangeAxis.setRange(xyPlot.getRangeAxis().getRange(), autoRange == AutoRange.OFF, false);
        xyPlot.setRangeAxis((ValueAxis)rangeAxis);
    }

    protected void configureDurationRangeAxis(JFreeChart chart) {
        this.configureDurationRangeAxis(chart, AutoRange.ON);
    }

    protected void configureDurationRangeAxisForSeconds(JFreeChart chart) {
        XYPlot xyPlot = chart.getXYPlot();
        DateAxis rangeAxis = new DateAxis();
        DurationFormat durationFormat = new DurationFormat(true);
        rangeAxis.setDateFormatOverride((DateFormat)durationFormat);
        rangeAxis.setLabel("Duration");
        xyPlot.setRangeAxis((ValueAxis)rangeAxis);
    }

    protected static enum NotifyListeners {
        OFF,
        ON;

    }

    protected static enum AutoRange {
        ON,
        OFF;

    }
}

