/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.BuildFailuresChart;
import com.atlassian.bamboo.charts.BuildTimesChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.core.i18n.I18nTextProvider;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public class CombinedBuildSummaryByBuildChart
extends AbstractBambooChart {
    private static final Logger log = Logger.getLogger(CombinedBuildSummaryByBuildChart.class);
    private final PlanIdentifier plan;
    private final List<ResultsSummary> filteredResults;
    private final I18nTextProvider i18n;

    public CombinedBuildSummaryByBuildChart(int height, int width, @NotNull PlanIdentifier plan, @NotNull List<? extends ResultsSummary> filteredResults, @NotNull I18nTextProvider i18n) {
        super(height, width, "", "", "");
        this.plan = plan;
        this.filteredResults = new ArrayList<ResultsSummary>(filteredResults);
        this.i18n = i18n;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        BuildTimesChart buildTimes = new BuildTimesChart(this.height, this.width, "", "", this.i18n.getText("buildResult.summary.duration"), this.plan, this.filteredResults, this.i18n.getText("buildResult.summary.duration"));
        buildTimes.setShortUrlUsed(true);
        buildTimes.setContextPath(this.getContextPath());
        XYPlot buildTimesPlot = buildTimes.getChart().getXYPlot();
        BuildFailuresChart buildFailures = new BuildFailuresChart(this.height, this.width, "", "", this.i18n.getText("job.summary.graph.duration.noOfFailedTests"), this.plan, this.filteredResults, this.i18n.getText("job.summary.graph.duration.failedTests"));
        buildFailures.setShortUrlUsed(true);
        buildFailures.setContextPath(this.getContextPath());
        XYPlot buildFailurePlot = buildFailures.getChart().getXYPlot();
        ResultsSummary firstResult = (ResultsSummary)Iterables.getFirst(this.filteredResults, null);
        ResultsSummary lastResult = (ResultsSummary)Iterables.getLast(this.filteredResults, null);
        int firstNumber = firstResult != null ? firstResult.getBuildNumber() : 0;
        int lastNumber = lastResult != null ? lastResult.getBuildNumber() : 0;
        JFreeChart chart = ChartUtil.createCombinedXYPlotNumberChart(buildTimesPlot, buildFailurePlot, "", firstNumber, lastNumber);
        return this.generateChartImage(chart);
    }
}

