/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.ChartManager;
import com.atlassian.bamboo.charts.ChartParameterHelper;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plugin.descriptor.ReportCollectorModuleDescriptor;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.search.IndexedBuildResultsSearcher;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.xy.XYDataset;

public class DefaultChartManager
implements ChartManager {
    private static final String PARAM_REPORT_KEY = "reportKey";
    private static final String PARAM_WIDTH = "width";
    private static final String PARAM_HEIGHT = "height";
    private static final int DEFAULT_CHART_WIDTH = 400;
    private static final int DEFAULT_CHART_HEIGHT = 320;
    private static final int REASONABLE_BRS_COUNT = 10000;
    private static final Logger log = Logger.getLogger(DefaultChartManager.class);
    private PluginAccessor pluginAccessor;
    private IndexedBuildResultsSearcher indexedBuildResultsSearcher;
    private CachedPlanManager cachedPlanManager;
    private ResultsSummaryManager resultsSummaryManager;
    private final PlanManager planManager;

    public DefaultChartManager(PluginAccessor pluginAccessor, IndexedBuildResultsSearcher indexedBuildResultsSearcher, CachedPlanManager cachedPlanManager, ResultsSummaryManager resultsSummaryManager, PlanManager planManager) {
        this.pluginAccessor = pluginAccessor;
        this.indexedBuildResultsSearcher = indexedBuildResultsSearcher;
        this.cachedPlanManager = cachedPlanManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.planManager = planManager;
    }

    @Override
    @Nullable
    public String getReportKey(Map<String, String[]> context) {
        return ChartParameterHelper.getFromContext(context, PARAM_REPORT_KEY);
    }

    @Override
    public List<ReportCollectorModuleDescriptor> getAvailableReports() {
        return Comparators.getModuleDescriptorNameOrdering().sortedCopy((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportCollectorModuleDescriptor.class));
    }

    @Override
    public ModuleDescriptor getReport(String reportKey) {
        return this.pluginAccessor.getEnabledPluginModule(reportKey);
    }

    @Override
    public List<ResultsSummary> prepareResultList(Map<String, String[]> contextMap) {
        log.trace((Object)"Generating Lucene query to search for build results");
        Query query = LuceneQueryBuilder.generateBrsQuery(contextMap, (CachedPlanManager)this.cachedPlanManager, (PlanManager)this.planManager);
        log.trace((Object)"Executing Lucene index search");
        List result = this.indexedBuildResultsSearcher.search(query, 10000).getList();
        log.debug((Object)String.format("Index search returned %d results", result.size()));
        return result;
    }

    @Override
    @Nullable
    public ReportCollector getReportCollector(List<ResultsSummary> resultsList, Map<String, String[]> contextMap) {
        String reportKey = this.getReportKey(contextMap);
        if (!StringUtils.isEmpty((CharSequence)reportKey)) {
            if (CollectionUtils.isNotEmpty(resultsList)) {
                ModuleDescriptor descriptor = this.pluginAccessor.getPluginModule(reportKey);
                if (descriptor != null) {
                    ReportCollector collector = (ReportCollector)descriptor.getModule();
                    collector.setResultsList(resultsList);
                    collector.setParams(contextMap);
                    return collector;
                }
                log.warn((Object)("Report collector not create, no app found to generate requested report " + reportKey));
            } else {
                log.info((Object)"Report collector not create, no results provided");
            }
        } else {
            log.warn((Object)"No report key specified, no report collector create");
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, Object> getReportData(@NotNull XYDataset dataSet, @NotNull Map<String, String[]> contextMap) {
        String reportKey = this.getReportKey(contextMap);
        int width = ChartParameterHelper.getNumericParameter(contextMap, PARAM_WIDTH, 400);
        int height = ChartParameterHelper.getNumericParameter(contextMap, PARAM_HEIGHT, 320);
        return this.generateReport(dataSet, reportKey, width, height);
    }

    @Override
    @NotNull
    public Map<String, Object> getReportData(@NotNull XYDataset dataSet, @NotNull String reportKey) {
        return this.generateReport(dataSet, reportKey, 400, 320);
    }

    @NotNull
    private Map<String, Object> generateReport(XYDataset dataSet, @NotNull String reportKey, int width, int height) {
        ReportCollectorModuleDescriptor moduleDescriptor = (ReportCollectorModuleDescriptor)this.pluginAccessor.getPluginModule(reportKey);
        BambooReportLineChart bambooChart = (BambooReportLineChart)moduleDescriptor.getChart();
        bambooChart.setChartTitle("");
        bambooChart.setHeight(height);
        bambooChart.setWidth(width);
        bambooChart.setDataSet(dataSet);
        bambooChart.setCachedPlanManager(this.cachedPlanManager);
        bambooChart.setResultsSummaryManager(this.resultsSummaryManager);
        return bambooChart.generateChartParams();
    }
}

