/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import org.apache.log4j.Logger;
import org.jfree.data.time.RegularTimePeriod;

public class TimePeriodAverageQueuedDurationCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodAverageQueuedDurationCollater.class);
    private int count = 0;
    private long totalDuration = 0L;

    public TimePeriodAverageQueuedDurationCollater() {
    }

    public TimePeriodAverageQueuedDurationCollater(RegularTimePeriod period) {
        this.period = period;
    }

    @Override
    public void addResult(ResultStatisticsProvider result) {
        if (result instanceof BuildResultsSummary) {
            BuildResultsSummary resultsSummary = (BuildResultsSummary)result;
            this.totalDuration += resultsSummary.getQueueDuration();
            ++this.count;
        }
    }

    public long getAverageDuration() {
        if (this.count != 0) {
            return this.totalDuration / (long)this.count;
        }
        return 0L;
    }

    @Override
    public double getValue() {
        return this.getAverageDuration();
    }
}

