/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import org.apache.log4j.Logger;
import org.jfree.data.time.RegularTimePeriod;

public class TimePeriodAverageSuccessDurationCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodAverageSuccessDurationCollater.class);
    private int count;
    private double totalDuration = 0.0;

    public TimePeriodAverageSuccessDurationCollater() {
    }

    public TimePeriodAverageSuccessDurationCollater(RegularTimePeriod period) {
        this.period = period;
    }

    @Override
    public void addResult(ResultStatisticsProvider result) {
        if (BuildState.SUCCESS.equals((Object)result.getBuildState())) {
            this.totalDuration += (double)result.getProcessingDuration();
            ++this.count;
        }
    }

    public double getAverageDuration() {
        if (this.count != 0) {
            return this.totalDuration / (double)this.count;
        }
        return 0.0;
    }

    @Override
    public double getValue() {
        return this.getAverageDuration();
    }
}

