/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.apache.log4j.Logger;

public class TimePeriodLabelUsageRatioCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodLabelUsageRatioCollater.class);
    private long count;
    private long labelUsages;
    private final String targetLabel;

    public TimePeriodLabelUsageRatioCollater(String targetLabel) {
        this.targetLabel = targetLabel;
    }

    @Override
    public void addResult(ResultStatisticsProvider result) {
        List labelNames;
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)result, ChainResultsSummary.class);
        if (chainResultsSummary != null && (labelNames = chainResultsSummary.getLabelNames()).contains(this.targetLabel)) {
            ++this.labelUsages;
        }
        ++this.count;
    }

    @Override
    public double getValue() {
        return this.getLabelUsageRatio();
    }

    public double getLabelUsageRatio() {
        return (double)this.labelUsages / (double)this.count * 100.0;
    }
}

