/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.timeperiod;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public abstract class AbstractTimePeriodGroupedChart
extends AbstractBambooChart {
    private static final Logger log = Logger.getLogger(AbstractTimePeriodGroupedChart.class);
    public static final String MONTH = "MONTH";
    public static final String YEAR = "YEAR";
    public static final String WEEK = "WEEK";
    public static final String DAY = "DAY";
    String periodRange;

    public AbstractTimePeriodGroupedChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, String periodRange) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.periodRange = periodRange;
    }

    protected TimeTableXYDataset populateDataSet(Collection<ResultStatisticsProvider> results, TimeTableXYDataset dataset, String seriesName) {
        TimePeriodCollater counter = null;
        if (results != null && !results.isEmpty()) {
            for (ResultStatisticsProvider result : results) {
                Date buildDate = result.getStatDate();
                if (counter == null) {
                    counter = this.createNewPeriod(buildDate, result, seriesName);
                    continue;
                }
                if (this.isInPeriod(counter.getPeriod(), buildDate)) {
                    counter.addResult(result);
                    continue;
                }
                this.writeCounterToDataSet(dataset, counter);
                counter = this.createNewPeriod(buildDate, result, seriesName);
            }
            this.writeCounterToDataSet(dataset, counter);
        }
        return dataset;
    }

    protected List getAllPeriodsBetweenDates(Date earliest, Date latest) {
        RegularTimePeriod firstPeriod = this.getPeriod(earliest, this.getPeriodRange());
        RegularTimePeriod lastPeriod = this.getPeriod(latest, this.getPeriodRange());
        RegularTimePeriod period = firstPeriod;
        ArrayList<RegularTimePeriod> periods = new ArrayList<RegularTimePeriod>();
        periods.add(firstPeriod);
        while (period.compareTo((Object)lastPeriod) < 0) {
            Date firstNextPeriod = new Date(period.getLastMillisecond() + 1L);
            RegularTimePeriod nextPeriod = this.getPeriod(firstNextPeriod, this.getPeriodRange());
            periods.add(nextPeriod);
            period = nextPeriod;
        }
        return periods;
    }

    protected abstract TimePeriodCollater createNewPeriod(Date var1, ResultStatisticsProvider var2, String var3);

    protected abstract void writeCounterToDataSet(TimeTableXYDataset var1, TimePeriodCollater var2);

    protected RegularTimePeriod getPeriod(Date date, String periodRange) {
        if (YEAR.equals(periodRange)) {
            return new Year(date);
        }
        if (WEEK.equals(periodRange)) {
            return new Week(date);
        }
        if (DAY.equals(periodRange)) {
            return new Day(date);
        }
        return new Month(date);
    }

    protected boolean isInPeriod(RegularTimePeriod time, Date date) {
        long firstMillisecond = time.getFirstMillisecond();
        long lastMillisecond = time.getLastMillisecond();
        long buildTime = date.getTime();
        return buildTime >= firstMillisecond && buildTime <= lastMillisecond;
    }

    public String getPeriodRange() {
        return this.periodRange;
    }
}

