/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.timeperiod;

import com.atlassian.bamboo.charts.collater.TimePeriodAverageDurationCollater;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodGroupedChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.core.i18n.I18nTextProvider;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class AverageDurationLineChart
extends AbstractTimePeriodGroupedChart
implements XYToolTipGenerator {
    private static final Logger log = Logger.getLogger(AverageDurationLineChart.class);
    private final List<ResultStatisticsProvider> results;
    private final I18nTextProvider i18n;

    public AverageDurationLineChart(int height, int width, String periodRange, List<? extends ResultStatisticsProvider> filteredResults, @NotNull I18nTextProvider i18n) {
        super(height, width, "", "", i18n.getText("build.common.duration"), periodRange);
        this.i18n = i18n;
        this.results = new ArrayList<ResultStatisticsProvider>(filteredResults);
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getChart();
        return this.generateChartImage(chart);
    }

    public JFreeChart getChart() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset = this.populateDataSet(this.results, dataset, null);
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chartTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot xyPlot = chart.getXYPlot();
        XYItemRenderer renderer = xyPlot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ChartUtil.COLOR_BLUE_OUTLINE);
        xyPlot.setRenderer(renderer);
        renderer.setToolTipGenerator((XYToolTipGenerator)this);
        xyPlot.setDomainAxis((ValueAxis)new DateAxis());
        this.configureDurationRangeAxis(chart);
        return chart;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double averageInMillis = NumberUtils.round((double)dataset.getYValue(0, item), (int)2);
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return timePeriod + ": " + this.i18n.getText("job.summary.graph.successfulBuilds.averageBuildTook", (Object[])new String[]{DurationUtils.getPrettyPrint((long)((long)averageInMillis))});
    }

    @Override
    protected TimePeriodCollater createNewPeriod(Date buildDate, ResultStatisticsProvider result, String seriesName) {
        TimePeriodAverageDurationCollater counter = new TimePeriodAverageDurationCollater(this.getPeriod(buildDate, this.getPeriodRange()));
        counter.addResult(result);
        return counter;
    }

    @Override
    protected void writeCounterToDataSet(TimeTableXYDataset dataset, TimePeriodCollater counter) {
        TimePeriodAverageDurationCollater avgDurationCounter = (TimePeriodAverageDurationCollater)counter;
        double averageDuration = avgDurationCounter.getAverageDuration();
        dataset.add((TimePeriod)counter.getPeriod(), averageDuration, "Average");
    }
}

