/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.timeperiod;

import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.collater.TimePeriodSuccessRatioCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodGroupedChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.core.i18n.I18nTextProvider;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;

public class SuccessRatioStackedAreaChart
extends AbstractTimePeriodGroupedChart
implements XYToolTipGenerator {
    private Collection<ResultStatisticsProvider> results;
    private final I18nTextProvider i18n;

    public SuccessRatioStackedAreaChart(int height, int width, I18nTextProvider i18n) {
        this(height, width, "MONTH", i18n);
    }

    public SuccessRatioStackedAreaChart(int height, int width, String periodRange, I18nTextProvider i18n) {
        this(height, width, periodRange, Collections.emptyList(), i18n);
    }

    public SuccessRatioStackedAreaChart(int height, int width, String periodRange, Collection<? extends ResultStatisticsProvider> results, @NotNull I18nTextProvider i18n) {
        super(height, width, "", "", i18n.getText("job.summary.graph.successfulBuilds.perCentSuccessful"), periodRange);
        this.i18n = i18n;
        this.results = new ArrayList<ResultStatisticsProvider>(results);
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getChart();
        return this.generateChartImage(chart);
    }

    public JFreeChart getChart() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset = this.populateDataSet(this.results, dataset, null);
        JFreeChart chart = ChartFactory.createStackedXYAreaChart((String)this.chartTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (TableXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setDataset(1, (XYDataset)dataset);
        if (dataset.getItemCount() > 0) {
            XYLineAndShapeRenderer shapeRenderer = new XYLineAndShapeRenderer(false, true);
            shapeRenderer.setSeriesShapesVisible(1, false);
            shapeRenderer.setSeriesLinesVisible(1, false);
            shapeRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-1.5, -1.5, 3.0, 3.0));
            shapeRenderer.setSeriesPaint(0, (Paint)ChartUtil.COLOR_GREEN_OUTLINE);
            shapeRenderer.setSeriesShapesFilled(0, true);
            shapeRenderer.setToolTipGenerator((XYToolTipGenerator)this);
            xyPlot.setRenderer(0, (XYItemRenderer)shapeRenderer);
            StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2();
            renderer.setSeriesPaint(0, (Paint)ChartUtil.COLOR_GREEN_PAINT);
            renderer.setSeriesPaint(1, (Paint)ChartUtil.COLOR_RED_PAINT);
            xyPlot.setRenderer(1, (XYItemRenderer)renderer);
            renderer.setToolTipGenerator((XYToolTipGenerator)this);
        }
        ValueAxis rangeAxis = xyPlot.getRangeAxis();
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setUpperBound(100.0);
        xyPlot.setDomainAxis((ValueAxis)new DateAxis());
        return chart;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double successRatio = NumberUtils.round((double)dataset.getYValue(0, item), (int)2);
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return timePeriod + ": " + this.i18n.getText("job.summary.graph.successfulBuilds.perCentOfRunsSuccessful", (Object[])new String[]{Double.toString(successRatio)});
    }

    @Override
    protected TimePeriodCollater createNewPeriod(Date buildDate, ResultStatisticsProvider result, String seriesName) {
        TimePeriodSuccessRatioCollater counter = new TimePeriodSuccessRatioCollater(this.getPeriod(buildDate, this.getPeriodRange()));
        counter.addResult(result);
        return counter;
    }

    @Override
    protected void writeCounterToDataSet(TimeTableXYDataset dataset, TimePeriodCollater counter) {
        TimePeriodSuccessRatioCollater successRatioCollater = (TimePeriodSuccessRatioCollater)counter;
        double successRatio = successRatioCollater.getSuccessRatio();
        dataset.add((TimePeriod)successRatioCollater.getPeriod(), successRatio, "Successes");
        dataset.add((TimePeriod)successRatioCollater.getPeriod(), 100.0 - successRatio, "Failure");
    }
}

