/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.charts.ChartBuilder;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ReportCollectorModuleDescriptor
extends AbstractBambooModuleDescriptor<ReportCollector> {
    private static final Logger log = Logger.getLogger(ReportCollectorModuleDescriptor.class);
    @Deprecated
    public static final String REPORTS_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.reports";
    private volatile Class<? extends ChartBuilder> chartClass;
    private boolean agentAwareReport;
    private String chartClassName;

    public ReportCollectorModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.chartClassName = element.valueOf("chartClass");
        this.agentAwareReport = Boolean.parseBoolean(element.valueOf("agentAwareReport"));
    }

    public void enabled() {
        super.enabled();
        this.validateClass();
    }

    private void validateClass() {
        if (this.chartClassName == null) {
            return;
        }
        try {
            this.chartClass = this.plugin.loadClass(this.chartClassName, ((Object)((Object)this)).getClass());
            try {
                Constructor<? extends ChartBuilder> noargConstructor = this.chartClass.getConstructor(new Class[0]);
                if (noargConstructor != null) {
                    this.chartClass.newInstance();
                }
            }
            catch (NoSuchMethodException noargConstructor) {}
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Could not load class: " + this.chartClassName, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new PluginParseException("Error retrieving dependency of class: " + this.chartClassName + ". Missing class: " + e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new PluginParseException("Class version is incompatible with current JVM: " + this.chartClassName, (Throwable)e);
        }
        catch (Throwable t) {
            throw new PluginParseException(t);
        }
    }

    public void disabled() {
        super.disabled();
        this.chartClass = null;
    }

    public ChartBuilder getChart() {
        return (ChartBuilder)this.instantiateClass(this.chartClass);
    }

    public boolean isAgentAwareReport() {
        return this.agentAwareReport;
    }
}

