/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.charts;

import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class AgentUtilizationLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    private static final Logger log = Logger.getLogger(AgentUtilizationLineChart.class);

    public AgentUtilizationLineChart() {
        this.setyAxisLabel("Agent Utilization");
    }

    @Override
    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double agentUtilization = dataset.getYValue(series, item);
        String agentName = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return agentName + " was utilized " + agentUtilization + " seconds for " + timePeriod;
    }

    @Override
    @NotNull
    protected Map<String, Object> generateChartImage(@NotNull JFreeChart chart, @NotNull Map<String, Object> params) {
        this.configureDurationRangeAxisForSeconds(chart);
        return super.generateChartImage(chart, params);
    }
}

