/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.charts;

import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildSummaryAverageQueuedDurationLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    private static final Logger log = Logger.getLogger(BuildSummaryAverageQueuedDurationLineChart.class);

    public BuildSummaryAverageQueuedDurationLineChart() {
        this.setyAxisLabel("Average Queued Duration (s)");
    }

    @Override
    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        int duration = (int)(dataset.getYValue(series, item) / 1000.0);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return buildKey + " on average spent " + duration + " seconds in the queue for for " + timePeriod;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = ChartUtil.createTimeSeriesChart(this.chartTitle, this.dataSet, this.xAxisLabel, this.yAxisLabel, this, this);
        this.configureDurationRangeAxis(chart);
        return this.generateChartImage(chart);
    }
}

