/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.charts;

import com.atlassian.bamboo.charts.utils.ChartDefaults;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.util.NumberUtils;
import java.awt.Paint;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildSummaryFailureRatioWithLabelUsageLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    private static final Logger log = Logger.getLogger(BuildSummaryFailureRatioWithLabelUsageLineChart.class);

    public BuildSummaryFailureRatioWithLabelUsageLineChart() {
        this.setyAxisLabel("%");
    }

    @Override
    public JFreeChart getJFreeChart() {
        JFreeChart jFreeChart1 = super.getJFreeChart();
        XYPlot xyPlot = jFreeChart1.getXYPlot();
        xyPlot.getRangeAxis().setUpperBound(100.0);
        if (this.dataSet.getSeriesCount() == 2) {
            ClusteredXYBarRenderer renderer = new ClusteredXYBarRenderer();
            ChartUtil.populateRendererDefaults(this, this, (AbstractXYItemRenderer)renderer);
            renderer.setSeriesPaint(0, (Paint)ChartDefaults.DIRTY_RED);
            renderer.setSeriesPaint(1, (Paint)ChartDefaults.DARK_BLUE);
            xyPlot.setRenderer((XYItemRenderer)renderer);
        }
        return jFreeChart1;
    }

    @Override
    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double percentage = NumberUtils.round((double)dataset.getYValue(series, item), (int)2);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return timePeriod + ": " + percentage + "% of runs for " + buildKey + " were successful";
    }
}

