/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.log;

import com.atlassian.bamboo.utils.OnlyLocalHomeLocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public abstract class BambooLog4jHomeLocatorContext {
    private static OnlyLocalHomeLocator externalHomeLocator;
    private static final OnlyLocalHomeLocator DEFAULT_HOME_LOCATOR;

    protected static OnlyLocalHomeLocator getHomeLocator() {
        return externalHomeLocator != null ? externalHomeLocator : DEFAULT_HOME_LOCATOR;
    }

    public static void setExternalHomeLocator(OnlyLocalHomeLocator homeLocator) {
        externalHomeLocator = homeLocator;
    }

    static {
        DEFAULT_HOME_LOCATOR = OnlyLocalHomeLocatorImpl.INSTANCE;
    }

    public static class OnlyLocalHomeLocatorImpl
    implements OnlyLocalHomeLocator {
        private final String initPropertyName = "bamboo.home";
        private final String propertiesFile = "bamboo-init.properties";
        public static OnlyLocalHomeLocatorImpl INSTANCE = new OnlyLocalHomeLocatorImpl();

        public String getHomePath() {
            String home = this.getHomeFromSystemProperty();
            if (home == null) {
                home = this.getHomeFromPropertiesFile();
            }
            return home != null ? home.trim() : null;
        }

        private String getHomeFromSystemProperty() {
            String sysProperty = System.getProperty(this.initPropertyName);
            return sysProperty;
        }

        private String getHomeFromPropertiesFile() {
            try {
                Properties props = new Properties();
                URL url = BambooLog4jHomeLocatorContext.class.getClassLoader().getResource("bamboo-init.properties");
                if (url != null) {
                    try (InputStream inputStream = url.openStream();){
                        props.load(inputStream);
                    }
                }
                if (props.getProperty(this.initPropertyName) != null) {
                    return props.getProperty(this.initPropertyName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }
}

