/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.log;

import com.atlassian.bamboo.log.BambooLog4jHomeLocatorContext;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.Advertiser;
import org.jetbrains.annotations.NotNull;

@Plugin(name="BambooRollingFile", category="Core", elementType="appender", printObject=true)
public class BambooRollingFileAppenderLog4j2
extends AbstractOutputStreamAppender<RollingFileManager> {
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;

    @NotNull
    private static String getDirectoryPrefix(String fileName) {
        String homePath;
        Object dirPrefix = "";
        File fileObject = new File(fileName);
        if (!fileObject.isAbsolute() && (homePath = BambooLog4jHomeLocatorContext.getHomeLocator().getHomePath()) != null) {
            dirPrefix = homePath + File.separator + "logs" + File.separator;
        }
        return dirPrefix;
    }

    private BambooRollingFileAppenderLog4j2(String name, Layout<? extends Serializable> layout, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        String dirPrefix = BambooRollingFileAppenderLog4j2.getDirectoryPrefix(fileName);
        this.fileName = dirPrefix + fileName;
        this.filePattern = dirPrefix + filePattern;
        this.advertiser = advertiser;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return stopped;
    }

    public void append(LogEvent event) {
        ((RollingFileManager)this.getManager()).checkRollover(event);
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return (T)((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<BambooRollingFileAppenderLog4j2> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public BambooRollingFileAppenderLog4j2 build() {
            String dirPrefix = BambooRollingFileAppenderLog4j2.getDirectoryPrefix(this.fileName);
            this.fileName = dirPrefix + this.fileName;
            this.filePattern = dirPrefix + this.filePattern;
            boolean isBufferedIo = this.isBufferedIo();
            int bufferSize = this.getBufferSize();
            if (this.getName() == null) {
                LOGGER.error("RollingFileAppender '{}': No name provided.", (Object)this.getName());
                return null;
            }
            if (!isBufferedIo && bufferSize > 0) {
                LOGGER.warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)bufferSize);
            }
            if (this.filePattern == null) {
                LOGGER.error("RollingFileAppender '{}': No file name pattern provided.", (Object)this.getName());
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("RollingFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            RollingFileManager manager = RollingFileManager.getFileManager((String)this.fileName, (String)this.filePattern, (boolean)this.append, (boolean)isBufferedIo, (TriggeringPolicy)this.policy, (RolloverStrategy)this.strategy, (String)this.advertiseUri, (Layout)layout, (int)bufferSize, (boolean)this.isImmediateFlush(), (boolean)this.createOnDemand, (String)this.filePermissions, (String)this.fileOwner, (String)this.fileGroup, (Configuration)this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new BambooRollingFileAppenderLog4j2(this.getName(), (Layout<? extends Serializable>)layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), !isBufferedIo || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B withAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withLocking(boolean locking) {
            this.locking = locking;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B withFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

