/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.log;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="BambooEscapingConverter", category="Converter")
@ConverterKeys(value={"bambooEscapedMessage"})
public class BambooEscapingConverter
extends LogEventPatternConverter {
    public static final String BAMBOO_LOG_MESSAGE_ESCAPE_ENABLED = "bamboo.log.message.escape.enabled";
    public static final String BAMBOO_LOG_MESSAGE_MAX_LENGTH = "bamboo.log.message.max.length";
    public static final String DEFAULT_MESSAGE_LENGTH = "10000";
    public static final String ENABLED_BY_DEFAULT = "true";
    public static final String GT = "&gt;";
    public static final String LT = "&lt;";
    public static final String NEWLINE_REPLACEMENT = System.lineSeparator() + " (log message continued...) ";
    public static final String TRUNCATED_LOG_WARNING = "... (This log message was truncated from %s characters to %s characters)";
    private final int maxLength = Integer.parseInt(System.getProperty("bamboo.log.message.max.length", "10000"));
    private final boolean isLogEscapeDisabled = !Boolean.parseBoolean(System.getProperty("bamboo.log.message.escape.enabled", "true"));

    protected BambooEscapingConverter(String name, String style) {
        super(name, style);
    }

    public static BambooEscapingConverter newInstance(String[] options) {
        return new BambooEscapingConverter("BambooEscapingConverter", null);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String correctLengthMessage;
        String originalMessage = event.getMessage().getFormattedMessage();
        String string = correctLengthMessage = originalMessage.length() > this.maxLength ? this.enforceLength(originalMessage, this.maxLength) : originalMessage;
        if (this.isLogEscapeDisabled) {
            toAppendTo.append(correctLengthMessage);
            return;
        }
        String escapedMessage = BambooEscapingConverter.escapeMessage(correctLengthMessage);
        toAppendTo.append(escapedMessage);
    }

    private String enforceLength(String message, int maxLength) {
        String shortenedMessage = message.substring(0, maxLength);
        String infoMessage = String.format(TRUNCATED_LOG_WARNING, message.length(), shortenedMessage.length());
        return shortenedMessage + infoMessage;
    }

    private static String escapeMessage(String message) {
        message = message.replace("<", LT);
        message = message.replace(">", GT);
        message = message.replaceAll("\\r\\n|\\r|\\n", NEWLINE_REPLACEMENT);
        return message;
    }
}

