/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtils {
    public static final String KEY_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String KEY_HTTP_PROXY_PORT = "http.proxyPort";
    public static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    public static final String HTTPS_SCHEME = "https";
    public static final String HTTP_SCHEME = "http";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_RANGE = "IF-Range";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_VARY = "Vary";
    public static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String HEADER_ETAG = "ETag";
    public static final String CONTENT_ACCEPT_RANGES_BYTES = "bytes";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    public static final String CONTENT_ENCODING_COMPRESS = "compress";
    public static final String CONTENT_ENCODING_X_COMPRESS = "x-compress";
    public static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final Set<String> NON_MUTATIVE_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE"));

    private HttpUtils() {
    }

    public static boolean isDefaultPort(@NotNull String scheme, int port) {
        return port == 80 && scheme.equals(HTTP_SCHEME) || port == 443 && scheme.equals(HTTPS_SCHEME);
    }

    @Nullable
    public static EndpointSpec getProxyForScheme(@Nullable String scheme) {
        Integer proxyPort;
        String proxyHost;
        if (HTTPS_SCHEME.equalsIgnoreCase(scheme) || scheme == null) {
            proxyHost = System.getProperty(KEY_HTTPS_PROXY_HOST);
            proxyPort = Integer.getInteger(KEY_HTTPS_PROXY_PORT, 443);
            if (proxyHost != null && proxyPort != null) {
                return new EndpointSpec(proxyHost, proxyPort);
            }
        }
        if (HTTP_SCHEME.equalsIgnoreCase(scheme) || scheme == null) {
            proxyHost = System.getProperty(KEY_HTTP_PROXY_HOST);
            proxyPort = Integer.getInteger(KEY_HTTP_PROXY_PORT, 80);
            if (proxyHost != null && proxyPort != null) {
                return new EndpointSpec(proxyHost, proxyPort);
            }
        }
        return null;
    }

    public static boolean canMethodMutateState(@NotNull String method) {
        return !NON_MUTATIVE_HTTP_METHODS.contains(method);
    }

    public static class EndpointSpec {
        @NotNull
        public final String host;
        @NotNull
        public final Integer port;

        public EndpointSpec(@NotNull String host, @NotNull Integer port) {
            this.host = host;
            this.port = port;
        }
    }
}

