/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.license;

import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.license.LicenseManagerFactory;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.config.ConfigurationException;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooLicenseManagerImpl
implements BambooLicenseManager {
    private static final Logger log = Logger.getLogger(BambooLicenseManagerImpl.class);
    public static final String BAMBOO_LICENSE_KEY = "Bamboo";
    private static final String LICENSE_STRING = "license.string";
    private static final String LICENSE_HASH = "license.hash";
    private static final String LICENSE_MESSAGE = "license.message";
    private final BootstrapManager bootstrapManager;
    private final Map<String, String> legacyLicenseStrings = new ConcurrentHashMap<String, String>(1);

    public BambooLicenseManagerImpl(@NotNull BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Nullable
    public BambooLicense getLicense() {
        return this.getLicense(this.getLicenseString());
    }

    @Nullable
    public String getLicenseString() {
        String licenseString = (String)this.bootstrapManager.getProperty(LICENSE_STRING);
        if (licenseString == null) {
            String key;
            String message = (String)this.bootstrapManager.getProperty(LICENSE_MESSAGE);
            String hash = (String)this.bootstrapManager.getProperty(LICENSE_HASH);
            if (hash != null && message != null && (licenseString = this.legacyLicenseStrings.get(key = hash + message)) == null) {
                try {
                    LicensePair pair = new LicensePair(message, hash);
                    licenseString = pair.getOriginalLicenseString();
                    this.legacyLicenseStrings.put(key, licenseString);
                }
                catch (LicenseException e) {
                    log.error((Object)"Could not load legacy license and no v2 license exists", (Throwable)e);
                }
            }
        }
        return licenseString;
    }

    public void setLicense(String license) {
        this.bootstrapManager.removeProperty(LICENSE_HASH);
        this.bootstrapManager.removeProperty(LICENSE_MESSAGE);
        this.bootstrapManager.setProperty(LICENSE_STRING, (Object)license);
        try {
            this.bootstrapManager.save();
        }
        catch (ConfigurationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public boolean authenticateLicense(String license) {
        try {
            BambooLicense bambooLicense = this.getLicense(license);
            return bambooLicense != null && !bambooLicense.isExpired() && !this.isMaintenanceExpiredForBuild(bambooLicense) && bambooLicense.isClusteringEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLicenseValid() {
        BambooLicense license = this.getLicense();
        return license != null && !license.isExpired();
    }

    private boolean isMaintenanceExpiredForBuild(BambooLicense license) {
        return license != null && license.getMaintenanceExpiryDate().getTime() < this.getBuildDate().getTime();
    }

    protected Date getBuildDate() {
        return BuildUtils.getCurrentBuildDate();
    }

    public boolean isMaintenanceExpiredForBuild() {
        BambooLicense license = this.getLicense();
        return this.isMaintenanceExpiredForBuild(license);
    }

    public int getAllowedNumberOfRemoteAgents() {
        BambooLicense license = this.getLicense();
        if (license != null) {
            return license.getMaximumNumberOfRemoteAgents();
        }
        return 0;
    }

    public int getAllowedNumberOfLocalAgents() {
        BambooLicense license = this.getLicense();
        if (license != null) {
            return license.getMaximumNumberOfLocalAgents();
        }
        return -1;
    }

    public int getAllowedNumberOfPlans() {
        BambooLicense license = this.getLicense();
        return this.getAllowedNumberOfPlans(license);
    }

    public int getAllowedNumberOfPlans(String licenseString) {
        return this.getAllowedNumberOfPlans(this.getLicense(licenseString));
    }

    private int getAllowedNumberOfPlans(BambooLicense license) {
        if (license != null) {
            return license.getMaximumNumberOfPlans();
        }
        return -1;
    }

    public boolean isStarter() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.STARTER, license);
    }

    public boolean isBasicEdition() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseEdition(LicenseEdition.BASIC, license);
    }

    public boolean isEvaluation() {
        BambooLicense license = this.getLicense();
        return license != null && license.isEvaluation();
    }

    public boolean isAcademic() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.ACADEMIC, license);
    }

    public boolean isDemonstration() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.DEMONSTRATION, license);
    }

    public boolean isDeveloper() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.DEVELOPER, license);
    }

    public boolean isCommunity() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.COMMUNITY, license);
    }

    public boolean isOpenSource() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.OPEN_SOURCE, license);
    }

    public boolean isCommercial() {
        BambooLicense license = this.getLicense();
        return license != null && this.isLicenseType(LicenseType.COMMERCIAL, license);
    }

    public boolean isDataCenter() {
        BambooLicense license = this.getLicense();
        return license != null && license.isClusteringEnabled();
    }

    private boolean isLicenseEdition(@NotNull LicenseEdition edition, @NotNull BambooLicense license) {
        return edition.equals((Object)license.getLicenseEdition());
    }

    private boolean isLicenseType(@NotNull LicenseType type, @NotNull BambooLicense license) {
        return type.equals((Object)license.getLicenseType());
    }

    @Nullable
    private BambooLicense getLicense(@Nullable String licenseString) {
        if (licenseString == null) {
            return null;
        }
        AtlassianLicense atlassianLicense = LicenseManagerFactory.get().getLicense(licenseString);
        return (BambooLicense)atlassianLicense.getProductLicense(Product.BAMBOO);
    }
}

