/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.embedder;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenConfiguration {
    private static final Logger log = Logger.getLogger(MavenConfiguration.class);
    private static final String MAVEN_HOME = "maven.home";
    private String alternateGlobalSettings;
    private String alternateUserSettings;
    private ClassWorld classWorld;
    private Logger logger;
    private Properties systemProperties;
    private Properties userProperties;
    private String workingDirectory;

    private MavenConfiguration() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAlternateGlobalSettings() {
        return this.alternateGlobalSettings;
    }

    public String getAlternateUserSettings() {
        return this.alternateUserSettings;
    }

    @NotNull
    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public String getExtClassPath() {
        return this.getProperty("maven.ext.class.path");
    }

    public String getLocalRepositoryPath() {
        return this.getProperty("maven.repo.local");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getMavenHome() {
        return this.getProperty(MAVEN_HOME);
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    private String getProperty(@NotNull String key) {
        String value = this.userProperties.getProperty(key);
        if (value == null) {
            value = this.systemProperties.getProperty(key);
        }
        return value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("alternateGlobalSettings", (Object)this.alternateGlobalSettings).add("alternateUserSettings", (Object)this.alternateUserSettings).add("systemProperties", (Object)this.systemProperties).add("userProperties", (Object)this.userProperties).toString();
    }

    public static class Builder {
        private String alternateGlobalSettings;
        private String alternateUserSettings;
        private ClassWorld classWorld;
        private String extClassPath;
        private String localRepositoryPath;
        private Logger logger;
        private String mavenHome;
        private Properties systemProperties = new Properties();
        private Properties userProperties = new Properties();
        private String workingDirectory = SystemUtils.USER_DIR;

        public Builder alternateGlobalSettings(@Nullable String alternateGlobalSettings) {
            this.alternateGlobalSettings = alternateGlobalSettings;
            return this;
        }

        public Builder alternateUserSettings(@Nullable String alternateUserSettings) {
            this.alternateUserSettings = alternateUserSettings;
            return this;
        }

        public Builder classWorld(@Nullable ClassWorld classWorld) {
            this.classWorld = classWorld;
            return this;
        }

        public Builder extClassPath(@Nullable String extClassPath) {
            this.extClassPath = extClassPath;
            return this;
        }

        public Builder localRepositoryPath(@Nullable String localRepositoryPath) {
            this.localRepositoryPath = localRepositoryPath;
            return this;
        }

        public Builder localRepositoryPath(@Nullable File localRepositoryPath) {
            this.localRepositoryPath = localRepositoryPath != null ? localRepositoryPath.getAbsolutePath() : null;
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder mavenHome(@Nullable String mavenHome) {
            this.mavenHome = mavenHome;
            return this;
        }

        public Builder systemProperties(@Nullable Properties properties) {
            this.systemProperties = properties;
            return this;
        }

        public Builder userProperties(@Nullable Properties properties) {
            this.userProperties = properties;
            return this;
        }

        public Builder workingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public MavenConfiguration build() {
            MavenConfiguration request = new MavenConfiguration();
            request.alternateGlobalSettings = this.alternateGlobalSettings;
            request.alternateUserSettings = this.alternateUserSettings;
            request.classWorld = this.classWorld != null ? this.classWorld : new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
            request.logger = this.logger;
            request.systemProperties = this.systemProperties;
            if (StringUtils.isNotEmpty((CharSequence)this.extClassPath)) {
                this.userProperties.setProperty("maven.ext.class.path", this.extClassPath);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.localRepositoryPath)) {
                this.userProperties.setProperty("maven.repo.local", this.localRepositoryPath);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.mavenHome)) {
                this.userProperties.setProperty(MavenConfiguration.MAVEN_HOME, this.mavenHome);
            }
            request.userProperties = this.userProperties;
            request.workingDirectory = this.workingDirectory;
            return request;
        }
    }
}

