/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.embedder;

import com.atlassian.bamboo.maven.DefaultModelResolver;
import com.atlassian.bamboo.maven.embedder.MavenConfiguration;
import com.atlassian.bamboo.maven.embedder.MavenEmbedderException;
import com.atlassian.bamboo.maven.embedder.MavenEmbedderService;
import com.atlassian.bamboo.maven.utils.MavenHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.annotations.NotNull;

public class MavenEmbedderServiceImpl
implements MavenEmbedderService {
    private static final Logger log = LogManager.getLogger(MavenEmbedderServiceImpl.class);
    private static final List<String> WHITELIST_SYSTEM_PROPERTIES = ImmutableList.of((Object)"java.home", (Object)"java.version", (Object)"os.name", (Object)"os.arch", (Object)"os.version", (Object)"user.home", (Object)"user.dir");

    @Override
    @NotNull
    public List<ProjectBuildingResult> buildProject(@NotNull File pomFile, @NotNull MavenConfiguration configuration) throws MavenEmbedderException {
        log.debug(String.format("Building project [%s], using configuration [%s]", pomFile.getAbsolutePath(), configuration));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            PlexusContainer plexusContainer = MavenHelper.buildPlexusContainer(configuration);
            ProjectBuilder projectBuilder = (ProjectBuilder)plexusContainer.lookup(ProjectBuilder.class);
            Properties systemProperties = this.getSystemProperties(configuration);
            MavenExecutionRequest mavenExecutionRequest = MavenHelper.createMavenRequest(plexusContainer, configuration);
            ProjectBuildingRequest projectBuildingRequest = mavenExecutionRequest.getProjectBuildingRequest().setSystemProperties(systemProperties).setRepositorySession(this.buildRepositorySystemSession(plexusContainer, mavenExecutionRequest)).setResolveDependencies(true).setValidationLevel(0);
            List list = projectBuilder.build(Collections.singletonList(pomFile), true, projectBuildingRequest);
            return list;
        }
        catch (Exception e) {
            throw new MavenEmbedderException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    @NotNull
    public ModelBuildingResult buildModel(@NotNull File pomFile, @NotNull MavenConfiguration configuration) throws MavenEmbedderException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            PlexusContainer plexusContainer = MavenHelper.buildPlexusContainer(configuration);
            ModelBuilder modelBuilder = (ModelBuilder)plexusContainer.lookup(ModelBuilder.class);
            ArtifactResolver artifactResolver = (ArtifactResolver)plexusContainer.lookup(ArtifactResolver.class);
            RemoteRepositoryManager remoteRepositoryManager = (RemoteRepositoryManager)plexusContainer.lookup(RemoteRepositoryManager.class);
            VersionRangeResolver versionRangeResolver = (VersionRangeResolver)plexusContainer.lookup(VersionRangeResolver.class);
            MavenExecutionRequest mavenExecutionRequest = MavenHelper.createMavenRequest(plexusContainer, configuration);
            RequestTrace trace = RequestTrace.newChild(null, (Object)mavenExecutionRequest);
            Properties systemProperties = this.getSystemProperties(configuration);
            DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest().setValidationLevel(0).setProcessPlugins(false).setProfiles(mavenExecutionRequest.getProfiles()).setActiveProfileIds(mavenExecutionRequest.getActiveProfiles()).setInactiveProfileIds(mavenExecutionRequest.getInactiveProfiles()).setSystemProperties(systemProperties).setUserProperties(configuration.getUserProperties()).setTwoPhaseBuilding(false).setPomFile(pomFile);
            modelRequest.setModelResolver((ModelResolver)new DefaultModelResolver(this.buildRepositorySystemSession(plexusContainer, mavenExecutionRequest), trace.newChild((Object)modelRequest), "mavenEmbedderService", artifactResolver, versionRangeResolver, remoteRepositoryManager, RepositoryUtils.toRepos((List)mavenExecutionRequest.getRemoteRepositories())));
            ModelBuildingResult modelBuildingResult = modelBuilder.build((ModelBuildingRequest)modelRequest);
            return modelBuildingResult;
        }
        catch (Exception e) {
            throw new MavenEmbedderException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @VisibleForTesting
    Properties getSystemProperties(MavenConfiguration configuration) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Maps.filterKeys((Map)System.getProperties(), WHITELIST_SYSTEM_PROPERTIES::contains));
        properties.putAll((Map<?, ?>)configuration.getSystemProperties());
        return properties;
    }

    private RepositorySystemSession buildRepositorySystemSession(@NotNull PlexusContainer plexusContainer, @NotNull MavenExecutionRequest mavenExecutionRequest) throws ComponentLookupException {
        DefaultMaven defaultMaven = (DefaultMaven)plexusContainer.lookup(Maven.class);
        return defaultMaven.newRepositorySession(mavenExecutionRequest);
    }
}

