/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.utils;

import com.atlassian.bamboo.maven.MavenNullLogger;
import com.atlassian.bamboo.maven.embedder.BambooMavenEmbedderLogger;
import com.atlassian.bamboo.maven.embedder.MavenConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenHelper {
    public static final String MAVEN_EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String CENTRAL_INVALID_REPO_URL = "http://repo.maven.apache.org/maven2";
    private static final String CENTRAL_VALID_REPO_URL = "https://repo.maven.apache.org/maven2";

    private MavenHelper() {
    }

    public static Predicate<Artifact> artifactIsSnapshot() {
        return ArtifactIsSnapshotPredicate.INSTANCE;
    }

    @NotNull
    public static List<String> addPropertyToCommand(@NotNull List<String> command, @NotNull String key, @NotNull String value) {
        command.add(1, String.format("-D%s=%s", key, value));
        return command;
    }

    private static Logger getMavenLogger(@NotNull MavenConfiguration configuration) {
        org.apache.log4j.Logger configLogger = configuration.getLogger();
        return configLogger != null ? new BambooMavenEmbedderLogger(configLogger) : new MavenNullLogger();
    }

    public static PlexusContainer buildPlexusContainer(@NotNull MavenConfiguration configuration) throws MalformedURLException, DuplicateRealmException, PlexusContainerException {
        final Logger logger = MavenHelper.getMavenLogger(configuration);
        BaseLoggerManager loggerManager = new BaseLoggerManager(){

            protected Logger createLogger(String s) {
                return logger;
            }
        };
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(configuration.getClassWorld()).setRealm(MavenHelper.setupContainerRealm(configuration)).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc);
        container.setLookupRealm(null);
        container.setLoggerManager((LoggerManager)loggerManager);
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
        Map data = eventSpyContext.getData();
        data.put("plexus", container);
        data.put("workingDirectory", configuration.getWorkingDirectory());
        data.put("systemProperties", configuration.getSystemProperties());
        data.put("userProperties", configuration.getUserProperties());
        return container;
    }

    private static ClassRealm setupContainerRealm(@NotNull MavenConfiguration configuration) throws DuplicateRealmException, MalformedURLException {
        String[] jars;
        ClassRealm containerRealm = null;
        String extClassPath = configuration.getExtClassPath();
        if (StringUtils.isNotEmpty((String)extClassPath) && (jars = StringUtils.split((String)extClassPath, (String)File.pathSeparator)).length > 0) {
            ClassWorld classWorld = configuration.getClassWorld();
            ClassRealm coreRealm = classWorld.getClassRealm("plexus.core");
            if (coreRealm == null) {
                coreRealm = (ClassRealm)classWorld.getRealms().iterator().next();
            }
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            configuration.getLogger().debug((Object)("Populating class realm " + extRealm.getId()));
            for (String jar : jars) {
                File file = MavenHelper.resolveFile(new File(jar), configuration.getWorkingDirectory());
                configuration.getLogger().debug((Object)("  Included " + file));
                extRealm.addURL(file.toURI().toURL());
            }
            extRealm.setParentRealm(coreRealm);
            containerRealm = extRealm;
        }
        return containerRealm;
    }

    @Nullable
    public static File getArtifact(String groupId, String artifactId, String version, String type, boolean offlineMode) throws MalformedURLException, ArtifactResolutionException, MavenExecutionRequestPopulationException, SettingsBuildingException, PlexusContainerException, DuplicateRealmException, ComponentLookupException {
        return MavenHelper.getArtifact(groupId, artifactId, version, type, null, offlineMode);
    }

    @Nullable
    public static File getArtifact(String groupId, String artifactId, String version, String type, String classifier, boolean offlineMode) throws MalformedURLException, PlexusContainerException, DuplicateRealmException, ComponentLookupException, MavenExecutionRequestPopulationException, SettingsBuildingException, ArtifactResolutionException {
        MavenConfiguration mavenConfiguration = MavenConfiguration.builder().build();
        PlexusContainer plexusContainer = MavenHelper.buildPlexusContainer(mavenConfiguration);
        MavenExecutionRequestPopulator mavenExecutionRequestPopulator = (MavenExecutionRequestPopulator)plexusContainer.lookup(MavenExecutionRequestPopulator.class);
        RepositorySystem repositorySystem = (RepositorySystem)plexusContainer.lookup(RepositorySystem.class);
        ResolutionErrorHandler resolutionErrorHandler = (ResolutionErrorHandler)plexusContainer.lookup(ResolutionErrorHandler.class);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, version, null, type, classifier, (ArtifactHandler)new DefaultArtifactHandler(type));
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequestPopulator.populateDefaults((MavenExecutionRequest)mavenExecutionRequest);
        mavenExecutionRequestPopulator.populateFromSettings((MavenExecutionRequest)mavenExecutionRequest, MavenHelper.getSettings(plexusContainer, mavenConfiguration));
        MavenHelper.forceHttpsCentralRepoUsage((MavenExecutionRequest)mavenExecutionRequest);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact((Artifact)artifact).setResolveRoot(true).setOffline(offlineMode).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(mavenExecutionRequest.getLocalRepository()).setRemoteRepositories(mavenExecutionRequest.getRemoteRepositories());
        ArtifactResolutionResult result = repositorySystem.resolve(request);
        resolutionErrorHandler.throwErrors(request, result);
        return artifact.getFile();
    }

    private static void forceHttpsCentralRepoUsage(MavenExecutionRequest request) {
        Stream.of(request.getRemoteRepositories(), request.getPluginArtifactRepositories()).flatMap(Collection::stream).filter(repository -> "central".equals(repository.getId()) && CENTRAL_INVALID_REPO_URL.equals(repository.getUrl())).forEach(repository -> repository.setUrl(CENTRAL_VALID_REPO_URL));
    }

    public static ArtifactRepository getLocalRepository(@NotNull PlexusContainer plexusContainer, @NotNull MavenConfiguration configuration) throws ComponentLookupException, SettingsBuildingException, InvalidRepositoryException {
        RepositorySystem repositorySystem = (RepositorySystem)plexusContainer.lookup(RepositorySystem.class);
        String localRepositoryPath = MavenHelper.getLocalRepositoryPath(plexusContainer, configuration);
        return repositorySystem.createLocalRepository(new File(localRepositoryPath));
    }

    public static MavenExecutionRequest createMavenRequest(@NotNull PlexusContainer plexusContainer, @NotNull MavenConfiguration configuration) throws ComponentLookupException, InvalidRepositoryException, MavenExecutionRequestPopulationException, SettingsBuildingException {
        MavenExecutionRequestPopulator mavenExecutionRequestPopulator = (MavenExecutionRequestPopulator)plexusContainer.lookup(MavenExecutionRequestPopulator.class);
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequestPopulator.populateDefaults((MavenExecutionRequest)mavenExecutionRequest);
        mavenExecutionRequestPopulator.populateFromSettings((MavenExecutionRequest)mavenExecutionRequest, MavenHelper.getSettings(plexusContainer, configuration));
        MavenHelper.forceHttpsCentralRepoUsage((MavenExecutionRequest)mavenExecutionRequest);
        return mavenExecutionRequest.setGlobalSettingsFile(MavenHelper.getGlobalSettingsFile(configuration)).setUserSettingsFile(MavenHelper.getUserSettingsFile(configuration)).setLocalRepository(MavenHelper.getLocalRepository(plexusContainer, configuration));
    }

    public static Settings getSettings(@NotNull PlexusContainer plexusContainer, @NotNull MavenConfiguration configuration) throws ComponentLookupException, SettingsBuildingException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest().setGlobalSettingsFile(MavenHelper.getGlobalSettingsFile(configuration)).setUserSettingsFile(MavenHelper.getUserSettingsFile(configuration)).setUserProperties(configuration.getUserProperties()).setSystemProperties(configuration.getSystemProperties());
        return ((SettingsBuilder)plexusContainer.lookup(SettingsBuilder.class)).build((SettingsBuildingRequest)settingsBuildingRequest).getEffectiveSettings();
    }

    private static File getGlobalSettingsFile(@NotNull MavenConfiguration configuration) {
        return (File)MoreObjects.firstNonNull((Object)MavenHelper.safeNewFile(configuration.getAlternateGlobalSettings()), (Object)new File(org.apache.commons.lang3.StringUtils.defaultString((String)configuration.getMavenHome(), (String)SystemUtils.USER_DIR), "conf/settings.xml"));
    }

    private static File getUserSettingsFile(@NotNull MavenConfiguration configuration) {
        return (File)MoreObjects.firstNonNull((Object)MavenHelper.safeNewFile(configuration.getAlternateUserSettings()), (Object)SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
    }

    @NotNull
    private static String getLocalRepositoryPath(@NotNull PlexusContainer plexusContainer, @NotNull MavenConfiguration configuration) throws SettingsBuildingException, ComponentLookupException {
        Settings settings;
        String path = configuration.getLocalRepositoryPath();
        if (path == null && (path = (settings = MavenHelper.getSettings(plexusContainer, configuration)).getLocalRepository()) == null) {
            path = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return path;
    }

    private static File resolveFile(File file, String workingDirectory) {
        if (file == null || file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    @Nullable
    private static File safeNewFile(@Nullable String path) {
        return path != null ? new File(path) : null;
    }

    private static enum ArtifactIsSnapshotPredicate implements Predicate<Artifact>
    {
        INSTANCE;


        public boolean apply(@Nullable Artifact input) {
            return ((Artifact)Preconditions.checkNotNull((Object)input)).isSnapshot();
        }
    }
}

