/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessTokenDao;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.atlassian.bamboo.accesstoken.MutableAccessToken;
import com.atlassian.bamboo.accesstoken.MutableAccessTokenImpl;
import com.atlassian.bamboo.accesstoken.MutableAccessTokenImpl_;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class HibernateAccessTokenDao
extends BambooHibernateObjectDao<MutableAccessToken>
implements AccessTokenDao {
    private static final Class<MutableAccessTokenImpl> PERSISTENT_CLASS = MutableAccessTokenImpl.class;

    @NotNull
    public Optional<MutableAccessToken> findByTokenId(final String tokenId) {
        return Optional.ofNullable((MutableAccessToken)new JpaUtils.CriteriaQuery<MutableAccessTokenImpl, MutableAccessToken>((SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory()), PERSISTENT_CLASS, MutableAccessToken.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(MutableAccessTokenImpl_.tokenId), (Object)tokenId));
            }
        }.uniqueResult());
    }

    @NotNull
    public List<MutableAccessToken> findByUserName(final String userName) {
        return new JpaUtils.CriteriaQuery<MutableAccessTokenImpl, MutableAccessToken>((SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory()), PERSISTENT_CLASS, MutableAccessToken.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(MutableAccessTokenImpl_.userName), (Object)userName));
            }
        }.getResultList();
    }

    public void deleteByUserName(final String userName) {
        new JpaUtils.CriteriaDelete<MutableAccessTokenImpl>(this.getSessionFactory(), MutableAccessTokenImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get(MutableAccessTokenImpl_.userName), (Object)userName));
            }
        }.executeUpdate();
    }

    public long countByUserName(String userName) {
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.eq((String)"userName", (Object)userName));
    }

    public boolean tokenWithNameAndUserNameExists(@NotNull String userName, @NotNull String tokenName) {
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"userName", (Object)userName), (Criterion)Restrictions.eq((String)"name", (Object)tokenName))) > 0L;
    }

    public long scrollTokensForExport(final @NotNull Consumer<MutableAccessToken> consumer) {
        ScrollHibernateCallback callback = new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.createQuery("select t from MutableAccessTokenImpl t");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                MutableAccessTokenImpl token = (MutableAccessTokenImpl)data.get(0);
                consumer.accept(token);
                session.evict((Object)token);
            }
        };
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    public long countTokensWithPermission(@NotNull AccessTokenPermission accessTokenPermission) {
        int permissionMask = (accessTokenPermission.getMask() << 1) - 1;
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.eq((String)"permissionsMask", (Object)permissionMask));
    }
}

