/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationDao;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationImpl;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ElasticImageConfigurationHibernateDao
extends BambooHibernateObjectDao
implements ElasticImageConfigurationDao {
    private static final Logger log = Logger.getLogger(ElasticImageConfigurationHibernateDao.class);
    private static final String PROPERTY_SHIPPED_WITH_BAMBOO = "shippedWithBamboo";
    private static final String PROPERTY_ELASTIC_CONFIG_NAME = "configurationName";
    private static final String PROPERTY_REGION = "region";
    private static final String PROPERTY_ROOT_DEVICE_TYPE = "rootDeviceType";
    private static final String PROPERTY_ARCHITECTURE = "architecture";
    private static final String PROPERTY_PLATFORM = "platform";
    private static final String PROPERTY_IMAGE_ID = "amiId";

    @NotNull
    public List<ElasticImageConfiguration> getAll() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ElasticImageConfiguration>>(){

            public List<ElasticImageConfiguration> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(ElasticImageConfigurationHibernateDao.this.getPersistentClass()).setCacheable(true).list();
            }
        });
    }

    public int getElasticAgentCountForImageConfigurationId(final long id) {
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("findNumberOfAgentsForImageConfiguration").setParameter("elasticConfigId", (Object)id).uniqueResult();
            }
        })).intValue();
    }

    public List<ElasticAgentDefinition> getElasticAgentsForImageConfigurationId(final long id) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ElasticAgentDefinition>>(){

            public List<ElasticAgentDefinition> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findAgentsForImageConfiguration").setParameter("elasticConfigId", (Object)id).list();
            }
        });
    }

    public List<ElasticImageConfiguration> getElasticImageConfigurationByAmi(final String amiId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ElasticImageConfiguration>>(){

            public List<ElasticImageConfiguration> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(ElasticImageConfigurationHibernateDao.this.getPersistentClass()).setCacheable(true).add((Criterion)Restrictions.eq((String)ElasticImageConfigurationHibernateDao.PROPERTY_IMAGE_ID, (Object)amiId)).list();
            }
        });
    }

    public int getBuildCountForImageConfigurationId(final long id) {
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                Query namedQuery = session.getNamedQuery("countBuildResultsForElasticImage");
                namedQuery.setParameter("elasticConfigId", (Object)id);
                return (Number)namedQuery.uniqueResult();
            }
        })).intValue();
    }

    public Class<ElasticImageConfigurationImpl> getPersistentClass() {
        return ElasticImageConfigurationImpl.class;
    }

    public void save(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        this.save((EntityObject)elasticImageConfiguration);
    }

    public void remove(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        this.remove((EntityObject)elasticImageConfiguration);
    }

    @NotNull
    public List<ElasticImageConfiguration> getImages(@Nullable AwsSupportConstants.Region region, @Nullable AwsSupportConstants.RootDeviceType rootDeviceType, @Nullable AwsSupportConstants.Architecture architecture, @Nullable AwsSupportConstants.Platform platform, @Nullable Boolean isShippedWithBamboo) {
        Criteria criteria = this.currentSession().createCriteria(this.getPersistentClass());
        this.addIfNotNull(criteria, PROPERTY_REGION, region);
        this.addIfNotNull(criteria, PROPERTY_ROOT_DEVICE_TYPE, rootDeviceType);
        this.addIfNotNull(criteria, PROPERTY_ARCHITECTURE, architecture);
        this.addIfNotNull(criteria, PROPERTY_PLATFORM, platform);
        this.addIfNotNull(criteria, PROPERTY_SHIPPED_WITH_BAMBOO, isShippedWithBamboo);
        return criteria.list();
    }

    private void addIfNotNull(@NotNull Criteria criteria, @NotNull String propertyName, @Nullable Object value) {
        if (value != null) {
            criteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        }
    }

    @NotNull
    public List<ElasticImageConfiguration> getElasticImageConfigurationsByName(final String configurationName, final AwsSupportConstants.Region region) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ElasticImageConfiguration>>(){

            public List<ElasticImageConfiguration> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ElasticImageConfigurationHibernateDao.this.getPersistentClass());
                criteria.add((Criterion)Restrictions.eq((String)ElasticImageConfigurationHibernateDao.PROPERTY_ELASTIC_CONFIG_NAME, (Object)configurationName));
                criteria.add((Criterion)Restrictions.eq((String)ElasticImageConfigurationHibernateDao.PROPERTY_REGION, (Object)region));
                return criteria.list();
            }
        });
    }

    public ElasticImageConfiguration findById(long id) {
        return (ElasticImageConfiguration)this.findById(id, ElasticImageConfigurationImpl.class);
    }
}

