/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.artifact;

import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.artifact.MutableArtifactImpl_;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ArtifactHibernateDao
extends StatelessSessionHibernateDaoSupport
implements ArtifactDao {
    private static final Logger log = Logger.getLogger(ArtifactHibernateDao.class);
    private static final Class<MutableArtifactImpl> PERSISTENT_CLASS = MutableArtifactImpl.class;
    private final TransactionAndHibernateTemplate transactionTemplate;
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public ArtifactHibernateDao(TransactionAndHibernateTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    private List<MutableArtifact> findArtifactsReferencedByVersions(final @NotNull PlanKey planKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MutableArtifact>>(){

            public List<MutableArtifact> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findVersionArtifactsByPlanKey").setParameter("planKey", (Object)planKey.getKey()).setParameter("sharedArtifact", (Object)true).list();
            }
        });
    }

    private List<MutableArtifact> findPlanArtifactsNotReferencedByVersions(final @NotNull PlanKey planKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MutableArtifact>>(){

            public List<MutableArtifact> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findNonVersionArtifactsByPlanKey").setParameter("planKey", (Object)planKey.getKey()).setParameter("globallyStored", (Object)false).list();
            }
        });
    }

    private List<MutableArtifact> findPlanArtifactsNotReferencedByVersions(final @NotNull PlanResultKey planResultKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MutableArtifact>>(){

            public List<MutableArtifact> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findNonVersionArtifactsByPlanResultKey").setParameter("planKey", (Object)planResultKey.getPlanKey().getKey()).setParameter("buildNumber", (Object)planResultKey.getBuildNumber()).setParameter("globallyStored", (Object)false).list();
            }
        });
    }

    public void save(MutableArtifact artifact) {
        this.getCacheAwareHibernateTemplate().saveOrUpdate((Object)artifact);
    }

    public List<MutableArtifact> findAll() {
        return this.getCacheAwareHibernateTemplate().find("from " + PERSISTENT_CLASS.getName(), new Object[0]);
    }

    @Nullable
    public MutableArtifact findById(long id) {
        return (MutableArtifact)this.getCacheAwareHibernateTemplate().get(PERSISTENT_CLASS, (Serializable)Long.valueOf(id));
    }

    public boolean isReferencedByVersion(final long artifactId) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("isArtifactReferencedByVersion").setParameter("artifactId", (Object)artifactId).uniqueResult();
            }
        })).intValue() > 0;
    }

    public List<MutableArtifact> findPlanResultArtifactsReferencedByVersion(@NotNull PlanResultKey planResultKey) {
        return this.currentSession().createNativeQuery("select        distinct {a.*} from ARTIFACT a, DEPLOYMENT_VERSION_ARTIFACT dva      where        a.CHAIN_ARTIFACT = :sharedArtifact and        a.PLAN_KEY = :planKey and        a.BUILD_NUMBER = :buildNumber and        a.ARTIFACT_ID = dva.ARTIFACT_ID").addEntity("a", MutableArtifactImpl.class).setParameter("planKey", (Object)planResultKey.getPlanKey().getKey()).setParameter("buildNumber", (Object)planResultKey.getBuildNumber()).setParameter("sharedArtifact", (Object)true).list();
    }

    public List<MutableArtifact> findPlanArtifactsReferencedByVersion(@NotNull PlanKey planKey) {
        return this.findArtifactsReferencedByVersions(planKey);
    }

    public void removeById(final long id) {
        new JpaUtils.CriteriaDelete<MutableArtifactImpl>(this.getSessionFactory(), MutableArtifactImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get(MutableArtifactImpl_.id), (Object)id));
            }
        }.executeUpdate();
    }

    public void removeByPlanKey(@NotNull PlanKey planKey) {
        this.getCacheAwareHibernateTemplate().deleteAll(this.findPlanArtifactsNotReferencedByVersions(planKey));
    }

    public void removeByPlanResultKey(@NotNull PlanResultKey planResultKey) {
        this.getCacheAwareHibernateTemplate().deleteAll(this.findPlanArtifactsNotReferencedByVersions(planResultKey));
    }

    public List<MutableArtifact> findOrphanedArtifacts() {
        return this.getCacheAwareHibernateTemplate().findByNamedQuery("findOrphanedArtifacts", new Object[0]);
    }

    public List<MutableArtifact> findOrphanedArtifactsByIds(@NotNull List<Long> artifactIds) {
        if (CollectionUtils.isEmpty(artifactIds)) {
            return Collections.emptyList();
        }
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            Query orphanedArtifactsQuery = BambooHibernateUtils.timed((Session)session).getNamedQuery("findOrphanedArtifactsByIds");
            return HibernateDaoUtils.listQuery(this.dbmsBean, orphanedArtifactsQuery, "artifactIds", artifactIds);
        });
    }

    public void removeAll(@NotNull Collection<MutableArtifact> artifacts) {
        Set<Long> ids = artifacts.stream().map(BambooIdProvider::getId).collect(Collectors.toSet());
        this.removeAllByIds(ids);
    }

    public void removeAllByIds(@NotNull Collection<Long> artifactIds) {
        new JpaUtils.PartitionedCriteriaDelete<MutableArtifactImpl, Long>(this.dbmsBean, this.getSessionFactory(), PERSISTENT_CLASS){

            @Override
            public void apply(List<Long> partition) {
                this.delete.where((Expression)this.entity.get(MutableArtifactImpl_.id).in(partition));
            }
        }.executeUpdates(artifactIds);
    }

    public void updatePlanKey(final @NotNull PlanKey originalPlanKey, final @NotNull PlanKey newPlanKey) {
        String SQL_UPDATE_PLAN_KEY = "update ARTIFACT set PLAN_KEY = ? where PLAN_KEY = ?";
        this.transactionTemplate.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try (PreparedStatement statement = connection.prepareStatement("update ARTIFACT set PLAN_KEY = ? where PLAN_KEY = ?");){
                    statement.setString(1, newPlanKey.getKey());
                    statement.setString(2, originalPlanKey.getKey());
                    JdbcUtils.runUpdateQuery(statement, "update ARTIFACT set PLAN_KEY = ? where PLAN_KEY = ?", "Artifact");
                }
            }
        });
    }

    @NotNull
    public Map<String, Long> findArtifactUsedStorageByLinkType() {
        return (Map)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Map<String, Long>>(){

            public Map<String, Long> doInHibernate(Session session) throws HibernateException {
                List artifactStorageSizeByLinkType = session.getNamedQuery("artifactStorageSizeByLinkType").list();
                HashMap<String, Long> result = new HashMap<String, Long>(artifactStorageSizeByLinkType.size());
                for (Object[] linkTypeAndSize : artifactStorageSizeByLinkType) {
                    result.put((String)linkTypeAndSize[0], (Long)linkTypeAndSize[1]);
                }
                return result;
            }
        });
    }
}

