/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.author.AuthorDataImpl;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionTemplate;

public class AuthorCreatorServiceImpl
implements AuthorCreatorService {
    @Inject
    private ExtendedAuthorManager extendedAuthorManager;
    @Inject
    private TransactionTemplate transactionTemplate;

    public synchronized void createAuthorIfMissing(AuthorContext author) {
        this.transactionTemplate.execute(transactionStatus -> {
            this.saveAuthorIfMissing(author);
            return null;
        });
    }

    public synchronized void createMissingAuthors(BuildContext buildContext) {
        BuildChanges buildChanges = buildContext.getBuildChanges();
        Set authors = buildChanges.getChanges().stream().map(CommitContext::getAuthorContext).collect(Collectors.toSet());
        this.createMissingAuthors(authors);
    }

    public synchronized void createMissingAuthors(@Nullable Iterable<? extends AuthorContext> authors) {
        if (authors != null) {
            this.transactionTemplate.execute(transactionStatus -> {
                for (AuthorContext author : authors) {
                    this.saveAuthorIfMissing(author);
                }
                return null;
            });
        }
    }

    private void saveAuthorIfMissing(AuthorContext authorContext) {
        AuthorDataImpl authorWithProcessedName = new AuthorDataImpl(authorContext);
        Author author = this.extendedAuthorManager.getAuthorByName(authorWithProcessedName.getName());
        if (author != null) {
            return;
        }
        try {
            this.extendedAuthorManager.createAndSaveAuthor((Author)new AuthorImpl(authorContext));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new author record for committer '" + authorContext.getName() + "'", e);
        }
    }
}

