/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanDiscriminatorRegistry;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.user.User;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AuthorHibernateDao
extends BambooHibernateObjectDao<ExtendedAuthor>
implements AuthorDao {
    private static final Logger log = Logger.getLogger(AuthorHibernateDao.class);
    private static final Class<? extends ExtendedAuthor> PERSISTENT_CLASS = AuthorImpl.class;
    private static final String FIELD_LINKED_USER_NAME = "linkedUserName";
    private final PlanDiscriminatorRegistry planDiscriminatorRegistry;

    public AuthorHibernateDao(PlanDiscriminatorRegistry planDiscriminatorRegistry) {
        this.planDiscriminatorRegistry = planDiscriminatorRegistry;
    }

    public ExtendedAuthor findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends ExtendedAuthor> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @Nullable
    public ExtendedAuthor getAuthorByName(final String name) {
        return (ExtendedAuthor)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<ExtendedAuthor>(){

            public ExtendedAuthor doInHibernate(Session session) throws HibernateException {
                List list = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"name", (Object)name)).addOrder(Order.asc((String)"id")).list();
                if (!list.isEmpty()) {
                    if (list.size() > 1) {
                        log.warn((Object)("Duplicate authors found in the database " + list.size() + " matching records for name: " + name));
                    }
                    return (ExtendedAuthor)list.get(0);
                }
                return null;
            }
        });
    }

    @NotNull
    public List<ResultsSummary> getBuildResultsFailedByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.findBuildResultsByBuildState(author, BuildState.FAILED, maxResultCount);
    }

    @NotNull
    public List<ResultsSummary> getBuildResultsSuccessfulByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.findBuildResultsByBuildState(author, BuildState.SUCCESS, maxResultCount);
    }

    @NotNull
    public List<ResultsSummary> getBuildResultsBrokenByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.findResultsByDeltaState(author, DeltaState.BROKEN, maxResultCount);
    }

    @NotNull
    public List<ResultsSummary> getBuildResultsFixedByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.findResultsByDeltaState(author, DeltaState.FIXED, maxResultCount);
    }

    public int getNumberOfFailedBuildsByAuthor(ExtendedAuthor author) {
        return this.getNumberOfBuildsByBuildState(author, BuildState.FAILED);
    }

    public int getNumberOfSuccessfulBuildsByAuthor(ExtendedAuthor author) {
        return this.getNumberOfBuildsByBuildState(author, BuildState.SUCCESS);
    }

    public int getNumberOfBuildFixedByAuthor(ExtendedAuthor author) {
        return this.getNumberOfBuildsByDeltaState(author, DeltaState.FIXED);
    }

    public int getNumberOfBuildBrokenByAuthor(ExtendedAuthor author) {
        return this.getNumberOfBuildsByDeltaState(author, DeltaState.BROKEN);
    }

    @NotNull
    public Set<ExtendedAuthor> getAllUnlinkedAuthors() {
        return Sets.newHashSet((Iterable)((Iterable)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ExtendedAuthor>>(){

            public List<ExtendedAuthor> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add(Restrictions.isNull((String)AuthorHibernateDao.FIELD_LINKED_USER_NAME)).list();
            }
        })));
    }

    @NotNull
    public List<ExtendedAuthor> getLinkedAuthorsForUser(User user) {
        return this.getLinkedAuthorsForUser(user.getName());
    }

    @NotNull
    private List<ExtendedAuthor> getLinkedAuthorsForUser(String username) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)FIELD_LINKED_USER_NAME, (Object)username)).list());
    }

    @NotNull
    public List<ResultsSummary> getBuildResultsTriggeredByAuthor(final ExtendedAuthor author, final int maxResultCount) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findBuildResultSummariesByAuthor").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("lifeCycleState", (Object)LifeCycleState.FINISHED.toString());
                if (maxResultCount > 0) {
                    query.setMaxResults(maxResultCount);
                }
                return query.list();
            }
        });
    }

    @NotNull
    public List<ResultsSummary> getRecentResultsTriggeredByAuthors(final List<ExtendedAuthor> authors, int daysToFilter) {
        DateTime todaysDate = new DateTime((Object)new Date());
        final DateTime startDate = todaysDate.minusDays(daysToFilter);
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLatestBuildResultSummariesByAuthors").setParameterList("authors", (Collection)authors).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("lifeCycleState", (Object)LifeCycleState.FINISHED.toString()).setParameter("fromDate", (Object)startDate.toDate()).list();
            }
        });
    }

    public int getNumberOfBuildsTriggeredByAuthor(final ExtendedAuthor author) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("countBuildResultSummariesByAuthor").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("lifeCycleState", (Object)LifeCycleState.FINISHED.toString()).uniqueResult();
            }
        })).intValue();
    }

    private int getNumberOfBuildsByDeltaState(final ExtendedAuthor author, final DeltaState deltaState) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("countBuildResultSummariesByAuthorAndDeltaState").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("deltaState", (Object)deltaState.toString()).uniqueResult();
            }
        })).intValue();
    }

    private int getNumberOfBuildsByBuildState(final ExtendedAuthor author, final BuildState buildState) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("countBuildResultSummariesByAuthorAndBuildState").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("buildState", (Object)buildState.toString()).uniqueResult();
            }
        })).intValue();
    }

    @NotNull
    private List<ResultsSummary> findResultsByDeltaState(final ExtendedAuthor author, final DeltaState deltaState, final int maxResultCount) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findBuildResultSummariesByAuthorAndDeltaState").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("deltaState", (Object)deltaState.toString());
                if (maxResultCount > 0) {
                    query.setMaxResults(maxResultCount);
                }
                return query.list();
            }
        });
    }

    @NotNull
    private List<ResultsSummary> findBuildResultsByBuildState(final ExtendedAuthor author, final BuildState buildState, final int maxResultCount) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findBuildResultSummariesByAuthorAndBuildState").setParameter("author", (Object)author).setParameterList("planTypes", AuthorHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("buildState", (Object)buildState.toString());
                if (maxResultCount > 0) {
                    query.setMaxResults(maxResultCount);
                }
                return query.list();
            }
        });
    }

    public void unlinkLinkedAuthors(@NotNull String username) {
        for (ExtendedAuthor author : this.getLinkedAuthorsForUser(username)) {
            author.setLinkedUserName(null);
            this.save(author);
        }
    }

    public void updateLinkedAuthors(@NotNull User user, @NotNull List<Long> authorIds) {
        this.unlinkLinkedAuthors(user);
        for (Long authorId : authorIds) {
            ExtendedAuthor author = this.findById(authorId);
            if (author == null) continue;
            author.setLinkedUserName(user.getName());
            this.save(author);
        }
    }

    @NotNull
    public List<Author> findAuthorsByLinkedUser(final @NotNull String userSearchString) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Author>>(){

            public List<Author> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("searchAuthorByLinkedUser").setParameter("authorQuery", (Object)AuthorHibernateDao.this.convertSearchTermToLikeExpression(userSearchString)).list();
            }
        });
    }

    @NotNull
    public List<Author> findAuthorsByName(final @NotNull String authorSearchString) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Author>>(){

            public List<Author> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("searchAuthorByName").setParameter("authorQuery", (Object)AuthorHibernateDao.this.convertSearchTermToLikeExpression(authorSearchString)).list();
            }
        });
    }

    @NotNull
    public List<Author> findAuthorsThatStartWith(final @NotNull String authorSearchString, final boolean unlinkedOnly) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Author>>(){

            public List<Author> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery(unlinkedOnly ? "searchUnlinkedAuthorsByName" : "searchAuthorByName").setParameter("authorQuery", (Object)(authorSearchString.toLowerCase() + "%")).list();
            }
        });
    }

    @NotNull
    public Set<Author> getAuthorsByResultSummary(final @NotNull ResultsSummary resultsSummary) {
        return Sets.newHashSet((Iterable)((Iterable)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Author>>(){

            public List<Author> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getAuthorsByResultSummary").setParameter("resultsSummary", (Object)resultsSummary).list();
            }
        })));
    }
}

