/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.BandanaItem;
import com.atlassian.bamboo.bandana.BandanaItemDao;
import com.atlassian.bamboo.bandana.BandanaItem_;
import com.atlassian.bamboo.hibernate.callbacks.BulkUpdate;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class BandanaItemDaoImpl
extends HibernateDaoSupport
implements BandanaItemDao {
    private static final Logger log = Logger.getLogger(BandanaItemDaoImpl.class);

    public BandanaItem getBandanaItem(@NotNull BambooBandanaContext bandanaContext, String key) {
        return (BandanaItem)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(BandanaItem.class);
            Root bandanaItem = q.from(BandanaItem.class);
            q.select((Selection)bandanaItem).where(new Predicate[]{cb.equal((Expression)bandanaItem.get(BandanaItem_.buildId), (Object)bandanaContext.getPlanId()), cb.equal((Expression)bandanaItem.get(BandanaItem_.chainId), (Object)bandanaContext.getChainId()), cb.equal((Expression)bandanaItem.get(BandanaItem_.key), (Object)key)});
            return (BandanaItem)session.createQuery(q).setMaxResults(1).uniqueResult();
        });
    }

    @NotNull
    public Collection<BandanaItem> findBandanaItems(@NotNull BambooBandanaContext bandanaContext) {
        return (Collection)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(BandanaItem.class);
            Root bandanaItem = q.from(BandanaItem.class);
            q.select((Selection)bandanaItem).where(new Predicate[]{cb.equal((Expression)bandanaItem.get(BandanaItem_.buildId), (Object)bandanaContext.getPlanId()), cb.equal((Expression)bandanaItem.get(BandanaItem_.chainId), (Object)bandanaContext.getChainId())});
            return session.createQuery(q).getResultList();
        });
    }

    @NotNull
    public Collection<String> findBandanaKeys(@NotNull BambooBandanaContext bandanaContext) {
        return (Collection)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(String.class);
            Root bandanaItem = q.from(BandanaItem.class);
            q.select((Selection)bandanaItem.get(BandanaItem_.key)).where(new Predicate[]{cb.equal((Expression)bandanaItem.get(BandanaItem_.buildId), (Object)bandanaContext.getPlanId()), cb.equal((Expression)bandanaItem.get(BandanaItem_.buildId), (Object)bandanaContext.getChainId())});
            return session.createQuery(q).getResultList();
        });
    }

    @NotNull
    public Collection<BandanaItem> getAllBandanaItems() {
        return (Collection)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(BandanaItem.class);
            Root bandanaItem = q.from(BandanaItem.class);
            q.select((Selection)bandanaItem);
            return session.createQuery(q).getResultList();
        });
    }

    public void save(@NotNull BandanaItem bandanaItem) {
        this.getHibernateTemplate().save((Object)bandanaItem);
    }

    public void saveOrUpdate(@NotNull BambooBandanaContext bandanaContext, String key, String xStreamData) {
        BandanaItem bandanaItem = this.getBandanaItem(bandanaContext, key);
        if (bandanaItem != null) {
            bandanaItem.setSerializedData(xStreamData);
            this.save(bandanaItem);
        } else {
            BandanaItem newBandanaItem = new BandanaItem(bandanaContext, key, xStreamData);
            this.save(newBandanaItem);
        }
    }

    public void removeAllFromContext(@NotNull BambooBandanaContext bandanaContext) {
        this.getHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from BandanaItem bi where bi.buildId = :buildId and bi.chainId = :chainId", "buildId", bandanaContext.getPlanId(), "chainId", bandanaContext.getChainId()));
    }

    public void remove(BambooBandanaContext bandanaContext, String key) {
        BandanaItem bandanaItem = this.getBandanaItem(bandanaContext, key);
        if (bandanaItem != null) {
            this.getHibernateTemplate().delete((Object)bandanaItem);
        }
    }
}

