/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.BuildNumberGeneratorDao;
import com.atlassian.bamboo.build.SetNewBuildNumberResult;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.number.PlanBuildNumbersImpl;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;

public class BuildNumberGeneratorDaoImpl
implements BuildNumberGeneratorDao {
    @Inject
    private SessionFactory sessionFactory;

    @Override
    public int generateBuildNumberNewTx(@NotNull PlanIdentifier planIdentifier) {
        Session session = this.sessionFactory.getCurrentSession();
        PlanBuildNumbersImpl planBuildNumbers = this.getBuildNumberObjectForPlanWithExclusiveLock(session, planIdentifier);
        Preconditions.checkState((planBuildNumbers != null ? 1 : 0) != 0, (Object)("No build numbers record for plan " + planIdentifier.getPlanKey()));
        int nextBuildNumber = planBuildNumbers.getNextBuildNumber();
        planBuildNumbers.setNextBuildNumber(nextBuildNumber + 1);
        session.saveOrUpdate((Object)planBuildNumbers);
        return nextBuildNumber;
    }

    @Override
    public void initBuildNumbers(@NotNull PlanIdentifier planIdentifier) {
        Session session = this.sessionFactory.getCurrentSession();
        PlanBuildNumbersImpl planBuildNumbers = new PlanBuildNumbersImpl(planIdentifier);
        session.save((Object)planBuildNumbers);
    }

    @Override
    public void initBuildNumbersNewTx(@NotNull PlanIdentifier planIdentifier) {
        this.initBuildNumbers(planIdentifier);
    }

    @Override
    public SetNewBuildNumberResult setNextBuildNumberNewTx(@NotNull PlanIdentifier planIdentifier, int newBuildNumber) {
        Session session = this.sessionFactory.getCurrentSession();
        PlanBuildNumbersImpl planBuildNumbers = this.getBuildNumberObjectForPlanWithExclusiveLock(session, planIdentifier);
        Preconditions.checkState((planBuildNumbers != null ? 1 : 0) != 0, (Object)("No build numbers record for plan " + planIdentifier.getPlanKey()));
        int oldBuildNumber = planBuildNumbers.getNextBuildNumber();
        if (oldBuildNumber < newBuildNumber) {
            planBuildNumbers.setNextBuildNumber(newBuildNumber);
            session.saveOrUpdate((Object)planBuildNumbers);
        }
        return new SetNewBuildNumberResult(oldBuildNumber, newBuildNumber);
    }

    @Override
    public int getNextBuildNumber(@NotNull PlanIdentifier planIdentifier) {
        Session session = this.sessionFactory.getCurrentSession();
        PlanBuildNumbersImpl planBuildNumbers = this.getBuildNumberObjectForPlan(session, planIdentifier);
        Preconditions.checkState((planBuildNumbers != null ? 1 : 0) != 0, (Object)("No build numbers record for plan " + planIdentifier.getPlanKey()));
        return planBuildNumbers.getNextBuildNumber();
    }

    private PlanBuildNumbersImpl getBuildNumberObjectForPlanWithExclusiveLock(Session session, @NotNull PlanIdentifier planIdentifier) {
        return (PlanBuildNumbersImpl)session.createCriteria(PlanBuildNumbersImpl.class).add((Criterion)Restrictions.eq((String)"planId", (Object)planIdentifier.getId())).setLockMode(LockMode.PESSIMISTIC_WRITE).uniqueResult();
    }

    private PlanBuildNumbersImpl getBuildNumberObjectForPlan(Session session, @NotNull PlanIdentifier planIdentifier) {
        return (PlanBuildNumbersImpl)session.createCriteria(PlanBuildNumbersImpl.class).add((Criterion)Restrictions.eq((String)"planId", (Object)planIdentifier.getId())).uniqueResult();
    }
}

