/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildNumberGeneratorDao;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.SetNewBuildNumberResult;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanIdentifier;
import org.jetbrains.annotations.NotNull;

public class BuildNumberGeneratorServiceImpl
implements BuildNumberGeneratorService {
    private final BuildNumberGeneratorDao buildNumberGeneratorDao;
    private final AuditLogService auditLogService;

    public BuildNumberGeneratorServiceImpl(BuildNumberGeneratorDao buildNumberGeneratorDao, AuditLogService auditLogService) {
        this.buildNumberGeneratorDao = buildNumberGeneratorDao;
        this.auditLogService = auditLogService;
    }

    public int generateBuildNumber(@NotNull PlanIdentifier planIdentifier) {
        try {
            return this.buildNumberGeneratorDao.generateBuildNumberNewTx(planIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not generate next build number for '" + planIdentifier.getPlanKey() + "'", e);
        }
    }

    public void initBuildNumbers(@NotNull PlanIdentifier planIdentifier) {
        try {
            this.buildNumberGeneratorDao.initBuildNumbers(planIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create build numbers record '" + planIdentifier.getPlanKey() + "'", e);
        }
    }

    @VisibleForTesting
    public void initBuildNumberWithinTransaction(@NotNull PlanIdentifier planIdentifier) {
        try {
            this.buildNumberGeneratorDao.initBuildNumbersNewTx(planIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create build numbers record '" + planIdentifier.getPlanKey() + "'", e);
        }
    }

    public boolean setBuildNumber(@NotNull PlanIdentifier planIdentifier, int newBuildNumber) {
        try {
            SetNewBuildNumberResult setNewBuildNumberResult = this.buildNumberGeneratorDao.setNextBuildNumberNewTx(planIdentifier, newBuildNumber);
            if (setNewBuildNumberResult.isBuildNumberChanged()) {
                this.auditLogService.log("buildNumber", String.valueOf(setNewBuildNumberResult.getOldBuildNumber()), String.valueOf(setNewBuildNumberResult.getRequestedNewBuildNumber()), (Key)planIdentifier.getPlanKey());
                return true;
            }
            return setNewBuildNumberResult.isBuildNumberStayedTheSame();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set build number for '" + planIdentifier.getPlanKey() + "'", e);
        }
    }

    public int getNextBuildNumber(@NotNull PlanIdentifier planIdentifier) {
        return this.buildNumberGeneratorDao.getNextBuildNumber(planIdentifier);
    }
}

