/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.MutablePlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequestDao;
import com.atlassian.bamboo.build.PlanBranchPullRequestEntity;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import java.util.List;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PlanBranchPullRequestDaoImpl
implements PlanBranchPullRequestDao {
    private static final Class<? extends MutablePlanBranchPullRequest> PERSISTENT_CLASS = PlanBranchPullRequestEntity.class;
    @Lazy
    @Autowired
    private SessionFactory sessionFactory;

    @NotNull
    public Optional<MutablePlanBranchPullRequest> findForChainBranch(long branchId) {
        return Optional.ofNullable((MutablePlanBranchPullRequest)this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"chainBranch.id", (Object)branchId)).uniqueResult());
    }

    @NotNull
    public Optional<MutablePlanBranchPullRequest> findForChainBranch(@NotNull PlanKey branchKey) {
        return Optional.ofNullable((MutablePlanBranchPullRequest)this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).createAlias("chainBranch", "chainBranch").add((Criterion)Restrictions.eq((String)"chainBranch.planKey", (Object)branchKey)).uniqueResult());
    }

    @NotNull
    public Optional<MutablePlanBranchPullRequest> findForChainAndPullRequest(long chainId, long pullRequestId) {
        return Optional.ofNullable((MutablePlanBranchPullRequest)this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).createAlias("chainBranch", "chainBranch").add((Criterion)Restrictions.eq((String)"chainBranch.master.id", (Object)chainId)).add((Criterion)Restrictions.eq((String)"vcsPullRequest.id", (Object)pullRequestId)).uniqueResult());
    }

    @NotNull
    public List<MutablePlanBranchPullRequest> findForChain(long chainId) {
        return this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).createAlias("chainBranch", "chainBranch").add((Criterion)Restrictions.eq((String)"chainBranch.master.id", (Object)chainId)).list();
    }

    @NotNull
    public Optional<MutablePlanBranchPullRequest> findForChainAndPullRequest(@NotNull PlanKey chainKey, long pullRequestId) {
        return Optional.ofNullable((MutablePlanBranchPullRequest)this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).createAlias("chainBranch", "chainBranch").createAlias("chainBranch.master", "chain").add((Criterion)Restrictions.eq((String)"chain.planKey", (Object)chainKey)).add((Criterion)Restrictions.eq((String)"vcsPullRequest.id", (Object)pullRequestId)).uniqueResult());
    }

    @NotNull
    public List<MutablePlanBranchPullRequest> findForPullRequest(long pullRequestId) {
        return this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"vcsPullRequest.id", (Object)pullRequestId)).list();
    }

    @NotNull
    public List<MutablePlanBranchPullRequest> findAll() {
        return this.sessionFactory.getCurrentSession().createCriteria(PERSISTENT_CLASS).list();
    }

    @NotNull
    public MutablePlanBranchPullRequest create(@NotNull ChainBranch chainBranch, @NotNull MutableVcsPullRequest vcsPullRequest) {
        Optional<MutablePlanBranchPullRequest> pullRequestLink = this.findForChainBranch(chainBranch.getId());
        if (pullRequestLink.isPresent()) {
            MutableVcsPullRequest existingPullRequest = pullRequestLink.get().getVcsPullRequest();
            throw new IllegalStateException(String.format("Some pull request (%d) is already linked to plan branch %s", existingPullRequest.getId(), chainBranch.getKey()));
        }
        PlanBranchPullRequestEntity planBranchPullRequest = new PlanBranchPullRequestEntity(chainBranch, vcsPullRequest);
        this.sessionFactory.getCurrentSession().save((Object)planBranchPullRequest);
        return planBranchPullRequest;
    }

    public boolean deleteForChainBranch(long branchId) {
        Optional<MutablePlanBranchPullRequest> planBranchPullRequest = this.findForChainBranch(branchId);
        planBranchPullRequest.ifPresent(entity -> this.sessionFactory.getCurrentSession().delete(entity));
        return planBranchPullRequest.isPresent();
    }

    public boolean deleteForChainBranch(@NotNull PlanKey planKey) {
        Optional<MutablePlanBranchPullRequest> planBranchPullRequest = this.findForChainBranch(planKey);
        planBranchPullRequest.ifPresent(entity -> this.sessionFactory.getCurrentSession().delete(entity));
        return planBranchPullRequest.isPresent();
    }

    public int deleteForVcsPullRequest(long pullRequestId) {
        List<MutablePlanBranchPullRequest> planBranchPullRequest = this.findForPullRequest(pullRequestId);
        planBranchPullRequest.forEach(entity -> this.sessionFactory.getCurrentSession().delete(entity));
        return planBranchPullRequest.size();
    }
}

