/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyDao;
import com.atlassian.bamboo.build.PlanDependencyImpl;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.core.bean.EntityObject;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class PlanDependencyHibernateDao
extends BambooHibernateObjectDao
implements PlanDependencyDao {
    private static final Logger log = Logger.getLogger(PlanDependencyHibernateDao.class);

    public Class getPersistentClass() {
        return PlanDependencyImpl.class;
    }

    @NotNull
    public Collection<PlanDependency> findAllDependencies() {
        return this.findAll();
    }

    @NotNull
    public Collection<PlanDependency> getChildPlanDependencies(final @NotNull PlanIdentifier plan) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(PlanDependencyHibernateDao.this.getPersistentClass()).setFetchMode("childPlan", FetchMode.JOIN).setFetchMode("parentPlan", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"parentPlan.id", (Object)plan.getId()));
                return criteria.list();
            }
        });
    }

    @NotNull
    public Collection<PlanDependency> getParentPlanDependencies(final @NotNull PlanIdentifier plan) {
        List objects = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(PlanDependencyHibernateDao.this.getPersistentClass()).setFetchMode("childPlan", FetchMode.JOIN).setFetchMode("parentPlan", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"childPlan.id", (Object)plan.getId()));
                return criteria.list();
            }
        });
        return objects;
    }

    @Nullable
    public Collection<PlanDependency> getChildNonEditableDependencies(final @NotNull PlanIdentifier plan) {
        List objects = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(PlanDependencyHibernateDao.this.getPersistentClass()).setFetchMode("childPlan", FetchMode.JOIN).setFetchMode("parentPlan", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"parentPlan.id", (Object)plan.getId())).add((Criterion)Restrictions.ne((String)"dependencyType", (Object)"atlassian.dependency.default"));
                return criteria.list();
            }
        });
        return objects;
    }

    @Nullable
    public Collection<PlanDependency> getParentNonEditableDependencies(final @NotNull PlanIdentifier plan) {
        List objects = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(PlanDependencyHibernateDao.this.getPersistentClass()).setFetchMode("childPlan", FetchMode.JOIN).setFetchMode("parentPlan", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"childPlan.id", (Object)plan.getId())).add((Criterion)Restrictions.ne((String)"dependencyType", (Object)"atlassian.dependency.default"));
                return criteria.list();
            }
        });
        return objects;
    }

    public void removeDependenciesForPlan(@NotNull PlanIdentifier plan) {
        Collection<PlanDependency> parents = this.getParentPlanDependencies(plan);
        for (PlanDependency parent : parents) {
            this.remove((EntityObject)((PlanDependencyImpl)parent));
        }
        Collection<PlanDependency> children = this.getChildPlanDependencies(plan);
        for (PlanDependency child : children) {
            this.remove((EntityObject)((PlanDependencyImpl)child));
        }
    }
}

