/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.build.artifact.DefaultArtifactLink;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ArtifactLinkHibernateDao
extends BambooHibernateObjectDao
implements ArtifactLinkDao {
    private static final Class<? extends ArtifactLink> PERSISTENT_CLASS = DefaultArtifactLink.class;
    private static final String LABEL = "artifact.label";
    private static final String BUILD_RESULTS_SUMMARY = "buildResultsSummary";
    private static final String LINK_TYPE = "artifact.linkType";

    public Class getPersistentClass() {
        return DefaultArtifactLink.class;
    }

    public void removeAll(@NotNull Collection<ArtifactLink> artifactLinkCollection) {
        this.getHibernateTemplate().deleteAll(artifactLinkCollection);
    }

    public void removeById(final long artifactLinkId) {
        new JpaUtils.CriteriaDelete<DefaultArtifactLink>(this.getSessionFactory(), DefaultArtifactLink.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("id"), (Object)artifactLinkId));
            }
        }.executeUpdate();
    }

    @NotNull
    public Collection<ArtifactLink> findArtifactLinks(@NotNull String label, @NotNull ResultsSummary resultsSummary) {
        return (Collection)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).createAlias("artifact", "artifact").add((Criterion)Restrictions.eq((String)LABEL, (Object)label)).add((Criterion)Restrictions.eq((String)BUILD_RESULTS_SUMMARY, (Object)resultsSummary)).list());
    }

    @NotNull
    public Collection<ArtifactLink> getArtifactLinks(final @NotNull ResultsSummary resultsSummary, final @Nullable String linkType) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ArtifactLink>>(){

            public List<ArtifactLink> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)ArtifactLinkHibernateDao.BUILD_RESULTS_SUMMARY, (Object)resultsSummary));
                if (linkType != null) {
                    criteria.createAlias("artifact", "artifact").add((Criterion)Restrictions.eq((String)ArtifactLinkHibernateDao.LINK_TYPE, (Object)linkType));
                }
                return criteria.list();
            }
        });
    }

    @NotNull
    public Collection<ArtifactLink> findArtifactsByChainResultKey(final @NotNull PlanResultKey chainResultKey) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ArtifactLink>>(){

            public List<ArtifactLink> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).createAlias(ArtifactLinkHibernateDao.BUILD_RESULTS_SUMMARY, ArtifactLinkHibernateDao.BUILD_RESULTS_SUMMARY).add((Criterion)Restrictions.eq((String)"buildResultsSummary.planKey", (Object)chainResultKey.getPlanKey())).add((Criterion)Restrictions.eq((String)"buildResultsSummary.buildNumber", (Object)chainResultKey.getBuildNumber())).list();
            }
        });
    }

    public long scrollArtifactLinksForExport(final @NotNull Consumer<ArtifactLink> consumer) {
        ScrollHibernateCallback callback = new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("artifactLinksForExport");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                long artifactLinkId = data.getLong(0);
                PlanKey brsPlanKey = (PlanKey)data.get(1);
                int brsBuildNumber = data.getInteger(2);
                Optional<PlanKey> pjrPlanKeyOpt = Optional.ofNullable((PlanKey)data.get(3));
                int pjrBuildNumber = data.getInteger(4);
                long artifactId = data.getLong(5);
                BuildResultsSummaryImpl buildResultsSummary = this.newBrs(brsPlanKey, brsBuildNumber);
                Optional<BuildResultsSummaryImpl> producerJobResult = pjrPlanKeyOpt.map(pjrPlanKey -> this.newBrs((PlanKey)pjrPlanKey, pjrBuildNumber));
                MutableArtifactImpl artifact = (MutableArtifactImpl)BambooHibernateUtils.createObjectWithId(MutableArtifactImpl.class, (long)artifactId);
                DefaultArtifactLink artifactLink = DefaultArtifactLink.createForExport((long)artifactLinkId, (ResultsSummary)buildResultsSummary, producerJobResult, (MutableArtifact)artifact);
                consumer.accept(artifactLink);
            }

            private BuildResultsSummaryImpl newBrs(@NotNull PlanKey brsPlanKey, int brsBuildNumber) {
                BuildResultsSummaryImpl buildResultsSummary = new BuildResultsSummaryImpl();
                buildResultsSummary.setPlanKey(brsPlanKey);
                buildResultsSummary.setBuildNumber(brsBuildNumber);
                return buildResultsSummary;
            }
        };
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }
}

