/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.dao;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.dao.AgentAssignmentDao;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.v2.build.agent.AgentAssignmentImpl;
import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;

public class AgentAssignmentDaoImpl
extends StatelessSessionHibernateDaoSupport
implements AgentAssignmentDao {
    private static final Class<? extends AgentAssignment> PERSISTANT_CLASS = AgentAssignmentImpl.class;
    private TransactionAndHibernateTemplate transactionTemplate;

    public AgentAssignmentDaoImpl(TransactionAndHibernateTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @NotNull
    public AgentAssignment save(@NotNull AgentAssignment agentAssignment) {
        return (AgentAssignment)this.getCacheAwareHibernateTemplate().execute(session -> {
            List list = session.createCriteria(PERSISTANT_CLASS).add((Criterion)Restrictions.eq((String)"executorId", (Object)agentAssignment.getExecutorId())).add((Criterion)Restrictions.eq((String)"executorType", (Object)agentAssignment.getExecutorType())).add((Criterion)Restrictions.eq((String)"executableId", (Object)agentAssignment.getExecutableId())).add((Criterion)Restrictions.eq((String)"executableType", (Object)agentAssignment.getExecutableType())).list();
            return (AgentAssignment)BambooIterables.getFirstOrElse((Iterable)list, () -> {
                HibernateDaoUtils.saveOrUpdate(this.getCacheAwareHibernateTemplate().getSessionFactory().getCurrentSession(), (BambooObject)agentAssignment);
                return agentAssignment;
            });
        });
    }

    public void removeAll(@NotNull Iterable<? extends BambooIdProvider> agentAssignmentIds) {
        this.transactionTemplate.doWork(connection -> JdbcUtils.runDeleteQuery(connection, "AGENT_ASSIGNMENT", "ASSIGNMENT_ID", agentAssignmentIds));
    }

    public AgentAssignment getAgentAssignment(long agentAssignmentId) {
        return (AgentAssignment)this.getCacheAwareHibernateTemplate().get(PERSISTANT_CLASS, (Serializable)Long.valueOf(agentAssignmentId));
    }

    @NotNull
    public List<AgentAssignment> getAssignmentsForEnvironment(long environmentId) {
        return this.getAssignmentsForExecutable(environmentId, AgentAssignment.ExecutableType.ENVIRONMENT);
    }

    @NotNull
    public List<AgentAssignment> getAssignmentsForExecutor(long executorId, @NotNull AgentAssignment.ExecutorType executorType) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTANT_CLASS).add((Criterion)Restrictions.eq((String)"executorType", (Object)executorType)).add((Criterion)Restrictions.eq((String)"executorId", (Object)executorId)).list());
    }

    @NotNull
    public List<AgentAssignment> getAssignmentsForExecutable(long executableId, @NotNull AgentAssignment.ExecutableType executableType) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTANT_CLASS).add((Criterion)Restrictions.eq((String)"executableType", (Object)executableType)).add((Criterion)Restrictions.eq((String)"executableId", (Object)executableId)).list());
    }

    @NotNull
    public List<AgentAssignment> findAll() {
        return this.getCacheAwareHibernateTemplate().find("from " + PERSISTANT_CLASS.getName(), new Object[0]);
    }
}

