/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.dao;

import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.EphemeralAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.dao.AgentDao;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.v2.build.agent.ElasticAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.ElasticAgentDefinitionImpl_;
import com.atlassian.bamboo.v2.build.agent.EphemeralAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.EphemeralAgentDefinitionImpl_;
import com.atlassian.bamboo.v2.build.agent.LocalAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.RemoteAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.RemoteAgentDefinitionImpl_;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class AgentHibernateDao
extends BambooHibernateObjectDao
implements AgentDao {
    private static final String ID_PROPERTY = "id";
    private static final String LAST_SHUTDOWN_TIME_PROPERTY = "lastShutdownTime";
    private static final String LAST_STARTUP_TIME_PROPERTY = "lastStartupTime";
    private static final String AGENT_TYPE_PARAM = "agentType";
    @Lazy
    @Inject
    private DbmsBean dbmsBean;
    private final ImmutableMap<Class<? extends PipelineDefinition>, Class<? extends PipelineDefinition>> CLASS_TO_ENTITY = new ImmutableMap.Builder().put(EphemeralAgentDefinition.class, EphemeralAgentDefinitionImpl.class).put(EphemeralAgentDefinitionImpl.class, EphemeralAgentDefinitionImpl.class).put(ElasticAgentDefinition.class, ElasticAgentDefinitionImpl.class).put(ElasticAgentDefinitionImpl.class, ElasticAgentDefinitionImpl.class).put(RemoteAgentDefinition.class, RemoteAgentDefinitionImpl.class).put(RemoteAgentDefinitionImpl.class, RemoteAgentDefinitionImpl.class).put(LocalAgentDefinition.class, LocalAgentDefinitionImpl.class).put(LocalAgentDefinitionImpl.class, LocalAgentDefinitionImpl.class).build();

    public Class getPersistentClass() {
        return PipelineDefinition.class;
    }

    @NotNull
    public PipelineDefinition saveAndReturn(@NotNull PipelineDefinition pipelineDefinition) {
        if (!(pipelineDefinition instanceof EntityObject)) {
            throw new IllegalArgumentException("Incorrect agent definition has been provided");
        }
        EntityObject definition = (EntityObject)pipelineDefinition;
        return (PipelineDefinition)this.getHibernateTemplate().execute(session -> {
            PipelineDefinition result;
            this.updateModificationData(definition);
            if (definition.getId() == -1L) {
                session.save((Object)definition);
                result = (PipelineDefinition)definition;
            } else {
                result = (PipelineDefinition)session.merge((Object)definition);
            }
            return result;
        });
    }

    public PipelineDefinition getAgentById(long id) {
        return this.findById(id, PipelineDefinition.class);
    }

    public LocalAgentDefinition getLocalAgentById(long id) {
        return (LocalAgentDefinition)this.findById(id, LocalAgentDefinitionImpl.class);
    }

    public RemoteAgentDefinition getRemoteAgentById(long id) {
        return (RemoteAgentDefinition)this.findById(id, RemoteAgentDefinitionImpl.class);
    }

    @Override
    public List<PipelineDefinition> findAll() {
        return this.find(PipelineDefinition.class);
    }

    public List<PipelineDefinition> findAllAgents() {
        return this.find(PipelineDefinition.class);
    }

    public List<RemoteAgentDefinition> findAllRemoteAgents() {
        return this.find(RemoteAgentDefinition.class);
    }

    public List<EphemeralAgentDefinition> findAllEphemeralAgents() {
        return this.find(EphemeralAgentDefinition.class);
    }

    public List<LocalAgentDefinition> findAllLocalAgents() {
        return this.find(LocalAgentDefinition.class);
    }

    public List<ElasticAgentDefinition> findNotShutDownElasticAgents() {
        return (List)this.getHibernateTemplate().execute(session -> {
            Criteria elasticCriteria = session.createCriteria(ElasticAgentDefinitionImpl.class);
            Criterion isLastShutdownTimeNull = Restrictions.isNull((String)LAST_SHUTDOWN_TIME_PROPERTY);
            Criterion isLastStartupTimeNotNull = Restrictions.isNotNull((String)LAST_STARTUP_TIME_PROPERTY);
            LogicalExpression isLastStartupTimePresentButWithoutShutdownTime = Restrictions.and((Criterion)isLastShutdownTimeNull, (Criterion)isLastStartupTimeNotNull);
            LogicalExpression isLastStartupTimeGreaterThanLastShutdownTime = Restrictions.and((Criterion)isLastStartupTimeNotNull, (Criterion)Restrictions.gtProperty((String)LAST_STARTUP_TIME_PROPERTY, (String)LAST_SHUTDOWN_TIME_PROPERTY));
            elasticCriteria.add((Criterion)Restrictions.or((Criterion)isLastStartupTimePresentButWithoutShutdownTime, (Criterion)isLastStartupTimeGreaterThanLastShutdownTime));
            return Lists.newArrayList((Iterable)elasticCriteria.list());
        });
    }

    public long getAgentCount(Class<? extends PipelineDefinition> agentDefinitionClass) {
        Class entityClass = (Class)this.CLASS_TO_ENTITY.get(agentDefinitionClass);
        Preconditions.checkArgument((entityClass != null ? 1 : 0) != 0, (String)"Unknown class: %s", agentDefinitionClass);
        return ((Number)this.getHibernateTemplate().execute(session -> (Number)session.getNamedQuery("findNumberOfAgents").setParameter(AGENT_TYPE_PARAM, (Object)entityClass).setCacheable(true).uniqueResult())).longValue();
    }

    public long getOfflineAgentCount(Class<? extends PipelineDefinition> agentDefinitionClass) {
        return (Long)new JpaUtils.CriteriaQuery<PipelineDefinition, Long>(this.getSessionFactory(), agentDefinitionClass, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.and((Expression)this.cb.isNotNull((Expression)this.entity.get(AgentHibernateDao.LAST_SHUTDOWN_TIME_PROPERTY)), (Expression)this.cb.or((Expression)this.cb.isNull((Expression)this.entity.get(AgentHibernateDao.LAST_STARTUP_TIME_PROPERTY)), (Expression)this.cb.greaterThan((Expression)this.entity.get(AgentHibernateDao.LAST_SHUTDOWN_TIME_PROPERTY), (Expression)this.entity.get(AgentHibernateDao.LAST_STARTUP_TIME_PROPERTY)))));
            }
        }.getSingleResult();
    }

    @NotNull
    public List<ElasticAgentDefinition> findAllElasticAgents(int firstResult, int maxResults) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(ElasticAgentDefinition.class).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.desc((String)LAST_SHUTDOWN_TIME_PROPERTY)).setCacheable(true).list());
    }

    @NotNull
    public List<ElasticAgentDefinition> findOfflineElasticAgents(int firstResult, int maxResults) {
        return new JpaUtils.CriteriaQuery<ElasticAgentDefinitionImpl, ElasticAgentDefinition>(this.getSessionFactory(), ElasticAgentDefinitionImpl.class, ElasticAgentDefinition.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and((Expression)this.cb.isNotNull((Expression)this.entity.get(AgentHibernateDao.LAST_SHUTDOWN_TIME_PROPERTY)), (Expression)this.cb.or((Expression)this.cb.isNull((Expression)this.entity.get(AgentHibernateDao.LAST_STARTUP_TIME_PROPERTY)), (Expression)this.cb.greaterThan((Expression)this.entity.get(AgentHibernateDao.LAST_SHUTDOWN_TIME_PROPERTY), (Expression)this.entity.get(AgentHibernateDao.LAST_STARTUP_TIME_PROPERTY))))).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(AgentHibernateDao.ID_PROPERTY))});
            }
        }.getResultList(firstResult, maxResults);
    }

    @NotNull
    public List<ElasticAgentDefinition> findAllElasticAgents(@NotNull Collection<String> instanceIds) {
        if (instanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        List elasticInstanceId = (List)this.getHibernateTemplate().execute(session -> HibernateDaoUtils.listCriteria(this.dbmsBean, () -> session.createCriteria(ElasticAgentDefinitionImpl.class), "elasticInstanceId", new ArrayList(instanceIds)));
        return Lists.newArrayList((Iterable)elasticInstanceId);
    }

    @NotNull
    private <T extends PipelineDefinition> List<T> find(Class<T> persistentClass) {
        String query = "FROM " + persistentClass.getName() + " result";
        List queryResult = (List)this.getHibernateTemplate().execute(session -> {
            Query queryObject = session.createQuery(query);
            queryObject.setCacheable(true);
            BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            return queryObject.list();
        });
        if (queryResult == null) {
            return new ArrayList();
        }
        ArrayList<PipelineDefinition> result = new ArrayList<PipelineDefinition>(queryResult.size());
        for (Object entityObject : queryResult) {
            if (!persistentClass.isInstance(entityObject)) continue;
            result.add((PipelineDefinition)entityObject);
        }
        return result;
    }

    @NotNull
    public List<PipelineDefinition> findAllAgentsWithNameLike(@NotNull String nameLike) {
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findAgentWithNameLike").setParameter("nameLike", (Object)nameLike).list());
    }

    public Set<PipelineDefinition> findAllAgentsForAgentIds(@NotNull Collection<Long> agentIds) {
        return Sets.newHashSet((Iterable)((Iterable)this.getHibernateTemplate().execute(session -> session.createCriteria(this.getPersistentClass()).add(Restrictions.in((String)ID_PROPERTY, (Collection)agentIds)).list())));
    }

    @Nullable
    public PipelineDefinition findAgentByName(@NotNull String name) {
        return (PipelineDefinition)this.getHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"name", (Object)name));
            return criteria.uniqueResult();
        });
    }

    @NotNull
    public List<PipelineDefinition> findAgentsByName(@NotNull String name) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"name", (Object)name));
            return criteria.list();
        });
    }

    public void updateAgentShutdownTime(@NotNull PipelineDefinition agentDefinition) {
        agentDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(final ElasticAgentDefinition pipelineDefinition) {
                new JpaUtils.CriteriaUpdate<ElasticAgentDefinitionImpl>(AgentHibernateDao.this.getSessionFactory(), ElasticAgentDefinitionImpl.class){

                    @Override
                    public void apply() {
                        this.update.set(this.entity.get(ElasticAgentDefinitionImpl_.lastShutdownTime), (Object)pipelineDefinition.getLastShutdownTime()).where((Expression)this.cb.equal((Expression)this.entity.get(AgentHibernateDao.ID_PROPERTY), (Object)pipelineDefinition.getId()));
                    }
                }.executeUpdate();
            }

            public void visitEphemeral(final EphemeralAgentDefinition pipelineDefinition) {
                new JpaUtils.CriteriaUpdate<EphemeralAgentDefinitionImpl>(AgentHibernateDao.this.getSessionFactory(), EphemeralAgentDefinitionImpl.class){

                    @Override
                    public void apply() {
                        this.update.set(this.entity.get(EphemeralAgentDefinitionImpl_.lastShutdownTime), (Object)pipelineDefinition.getLastShutdownTime()).where((Expression)this.cb.equal((Expression)this.entity.get(AgentHibernateDao.ID_PROPERTY), (Object)pipelineDefinition.getId()));
                    }
                }.executeUpdate();
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            }

            public void visitRemote(final RemoteAgentDefinition pipelineDefinition) {
                new JpaUtils.CriteriaUpdate<RemoteAgentDefinitionImpl>(AgentHibernateDao.this.getSessionFactory(), RemoteAgentDefinitionImpl.class){

                    @Override
                    public void apply() {
                        this.update.set(this.entity.get(RemoteAgentDefinitionImpl_.lastShutdownTime), (Object)pipelineDefinition.getLastShutdownTime()).where((Expression)this.cb.equal((Expression)this.entity.get(AgentHibernateDao.ID_PROPERTY), (Object)pipelineDefinition.getId()));
                    }
                }.executeUpdate();
            }
        });
    }
}

